/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderPainting
extends Render<EntityPainting> {
    private static final ResourceLocation KRISTOFFER_PAINTING_TEXTURE = new ResourceLocation("textures/painting/paintings_kristoffer_zetterstrand.png");

    public RenderPainting(RenderManager p_i46150_1_) {
        super(p_i46150_1_);
    }

    @Override
    public void doRender(EntityPainting p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        GlStateManager.pushMatrix();
        GlStateManager.translate(p_doRender_2_, p_doRender_4_, p_doRender_6_);
        GlStateManager.rotate(180.0f - p_doRender_8_, 0.0f, 1.0f, 0.0f);
        GlStateManager.enableRescaleNormal();
        this.bindEntityTexture(p_doRender_1_);
        EntityPainting.EnumArt lvt_10_1_ = p_doRender_1_.art;
        float lvt_11_1_ = 0.0625f;
        GlStateManager.scale(0.0625f, 0.0625f, 0.0625f);
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        this.renderPainting(p_doRender_1_, lvt_10_1_.sizeX, lvt_10_1_.sizeY, lvt_10_1_.offsetX, lvt_10_1_.offsetY);
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityPainting p_getEntityTexture_1_) {
        return KRISTOFFER_PAINTING_TEXTURE;
    }

    private void renderPainting(EntityPainting p_renderPainting_1_, int p_renderPainting_2_, int p_renderPainting_3_, int p_renderPainting_4_, int p_renderPainting_5_) {
        float lvt_6_1_ = (float)(-p_renderPainting_2_) / 2.0f;
        float lvt_7_1_ = (float)(-p_renderPainting_3_) / 2.0f;
        float lvt_8_1_ = 0.5f;
        float lvt_9_1_ = 0.75f;
        float lvt_10_1_ = 0.8125f;
        float lvt_11_1_ = 0.0f;
        float lvt_12_1_ = 0.0625f;
        float lvt_13_1_ = 0.75f;
        float lvt_14_1_ = 0.8125f;
        float lvt_15_1_ = 0.001953125f;
        float lvt_16_1_ = 0.001953125f;
        float lvt_17_1_ = 0.7519531f;
        float lvt_18_1_ = 0.7519531f;
        float lvt_19_1_ = 0.0f;
        float lvt_20_1_ = 0.0625f;
        for (int lvt_21_1_ = 0; lvt_21_1_ < p_renderPainting_2_ / 16; ++lvt_21_1_) {
            for (int lvt_22_1_ = 0; lvt_22_1_ < p_renderPainting_3_ / 16; ++lvt_22_1_) {
                float lvt_23_1_ = lvt_6_1_ + (float)((lvt_21_1_ + 1) * 16);
                float lvt_24_1_ = lvt_6_1_ + (float)(lvt_21_1_ * 16);
                float lvt_25_1_ = lvt_7_1_ + (float)((lvt_22_1_ + 1) * 16);
                float lvt_26_1_ = lvt_7_1_ + (float)(lvt_22_1_ * 16);
                this.setLightmap(p_renderPainting_1_, (lvt_23_1_ + lvt_24_1_) / 2.0f, (lvt_25_1_ + lvt_26_1_) / 2.0f);
                float lvt_27_1_ = (float)(p_renderPainting_4_ + p_renderPainting_2_ - lvt_21_1_ * 16) / 256.0f;
                float lvt_28_1_ = (float)(p_renderPainting_4_ + p_renderPainting_2_ - (lvt_21_1_ + 1) * 16) / 256.0f;
                float lvt_29_1_ = (float)(p_renderPainting_5_ + p_renderPainting_3_ - lvt_22_1_ * 16) / 256.0f;
                float lvt_30_1_ = (float)(p_renderPainting_5_ + p_renderPainting_3_ - (lvt_22_1_ + 1) * 16) / 256.0f;
                Tessellator lvt_31_1_ = Tessellator.getInstance();
                VertexBuffer lvt_32_1_ = lvt_31_1_.getBuffer();
                lvt_32_1_.begin(7, DefaultVertexFormats.POSITION_TEX_NORMAL);
                lvt_32_1_.pos(lvt_23_1_, lvt_26_1_, -0.5).tex(lvt_28_1_, lvt_29_1_).normal(0.0f, 0.0f, -1.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_26_1_, -0.5).tex(lvt_27_1_, lvt_29_1_).normal(0.0f, 0.0f, -1.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_25_1_, -0.5).tex(lvt_27_1_, lvt_30_1_).normal(0.0f, 0.0f, -1.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_25_1_, -0.5).tex(lvt_28_1_, lvt_30_1_).normal(0.0f, 0.0f, -1.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_25_1_, 0.5).tex(0.75, 0.0).normal(0.0f, 0.0f, 1.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_25_1_, 0.5).tex(0.8125, 0.0).normal(0.0f, 0.0f, 1.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_26_1_, 0.5).tex(0.8125, 0.0625).normal(0.0f, 0.0f, 1.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_26_1_, 0.5).tex(0.75, 0.0625).normal(0.0f, 0.0f, 1.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_25_1_, -0.5).tex(0.75, 0.001953125).normal(0.0f, 1.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_25_1_, -0.5).tex(0.8125, 0.001953125).normal(0.0f, 1.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_25_1_, 0.5).tex(0.8125, 0.001953125).normal(0.0f, 1.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_25_1_, 0.5).tex(0.75, 0.001953125).normal(0.0f, 1.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_26_1_, 0.5).tex(0.75, 0.001953125).normal(0.0f, -1.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_26_1_, 0.5).tex(0.8125, 0.001953125).normal(0.0f, -1.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_26_1_, -0.5).tex(0.8125, 0.001953125).normal(0.0f, -1.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_26_1_, -0.5).tex(0.75, 0.001953125).normal(0.0f, -1.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_25_1_, 0.5).tex(0.751953125, 0.0).normal(-1.0f, 0.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_26_1_, 0.5).tex(0.751953125, 0.0625).normal(-1.0f, 0.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_26_1_, -0.5).tex(0.751953125, 0.0625).normal(-1.0f, 0.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_23_1_, lvt_25_1_, -0.5).tex(0.751953125, 0.0).normal(-1.0f, 0.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_25_1_, -0.5).tex(0.751953125, 0.0).normal(1.0f, 0.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_26_1_, -0.5).tex(0.751953125, 0.0625).normal(1.0f, 0.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_26_1_, 0.5).tex(0.751953125, 0.0625).normal(1.0f, 0.0f, 0.0f).endVertex();
                lvt_32_1_.pos(lvt_24_1_, lvt_25_1_, 0.5).tex(0.751953125, 0.0).normal(1.0f, 0.0f, 0.0f).endVertex();
                lvt_31_1_.draw();
            }
        }
    }

    private void setLightmap(EntityPainting p_setLightmap_1_, float p_setLightmap_2_, float p_setLightmap_3_) {
        int lvt_4_1_ = MathHelper.floor(p_setLightmap_1_.posX);
        int lvt_5_1_ = MathHelper.floor(p_setLightmap_1_.posY + (double)(p_setLightmap_3_ / 16.0f));
        int lvt_6_1_ = MathHelper.floor(p_setLightmap_1_.posZ);
        EnumFacing lvt_7_1_ = p_setLightmap_1_.facingDirection;
        if (lvt_7_1_ == EnumFacing.NORTH) {
            lvt_4_1_ = MathHelper.floor(p_setLightmap_1_.posX + (double)(p_setLightmap_2_ / 16.0f));
        }
        if (lvt_7_1_ == EnumFacing.WEST) {
            lvt_6_1_ = MathHelper.floor(p_setLightmap_1_.posZ - (double)(p_setLightmap_2_ / 16.0f));
        }
        if (lvt_7_1_ == EnumFacing.SOUTH) {
            lvt_4_1_ = MathHelper.floor(p_setLightmap_1_.posX - (double)(p_setLightmap_2_ / 16.0f));
        }
        if (lvt_7_1_ == EnumFacing.EAST) {
            lvt_6_1_ = MathHelper.floor(p_setLightmap_1_.posZ + (double)(p_setLightmap_2_ / 16.0f));
        }
        int lvt_8_1_ = this.renderManager.world.getCombinedLight(new BlockPos(lvt_4_1_, lvt_5_1_, lvt_6_1_), 0);
        int lvt_9_1_ = lvt_8_1_ % 65536;
        int lvt_10_1_ = lvt_8_1_ / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, lvt_9_1_, lvt_10_1_);
        GlStateManager.color(1.0f, 1.0f, 1.0f);
    }
}

