/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCape;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerDeadmau5Head;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderPlayer
extends RenderLivingBase<AbstractClientPlayer> {
    private final boolean smallArms;

    public RenderPlayer(RenderManager p_i46102_1_) {
        this(p_i46102_1_, false);
    }

    public RenderPlayer(RenderManager p_i46103_1_, boolean p_i46103_2_) {
        super(p_i46103_1_, new ModelPlayer(0.0f, p_i46103_2_), 0.5f);
        this.smallArms = p_i46103_2_;
        this.addLayer(new LayerBipedArmor(this));
        this.addLayer(new LayerHeldItem(this));
        this.addLayer(new LayerArrow(this));
        this.addLayer(new LayerDeadmau5Head(this));
        this.addLayer(new LayerCape(this));
        this.addLayer(new LayerCustomHead(this.getMainModel().bipedHead));
        this.addLayer(new LayerElytra(this));
    }

    @Override
    public ModelPlayer getMainModel() {
        return (ModelPlayer)super.getMainModel();
    }

    @Override
    public void doRender(AbstractClientPlayer p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        if (MinecraftForge.EVENT_BUS.post(new RenderPlayerEvent.Pre(p_doRender_1_, this, p_doRender_9_, p_doRender_2_, p_doRender_4_, p_doRender_6_))) {
            return;
        }
        if (!p_doRender_1_.isUser() || this.renderManager.renderViewEntity == p_doRender_1_) {
            double d0 = p_doRender_4_;
            if (p_doRender_1_.isSneaking() && !(p_doRender_1_ instanceof EntityPlayerSP)) {
                d0 = p_doRender_4_ - 0.125;
            }
            this.setModelVisibilities(p_doRender_1_);
            GlStateManager.enableBlendProfile(GlStateManager.Profile.PLAYER_SKIN);
            super.doRender(p_doRender_1_, p_doRender_2_, d0, p_doRender_6_, p_doRender_8_, p_doRender_9_);
            GlStateManager.disableBlendProfile(GlStateManager.Profile.PLAYER_SKIN);
        }
        MinecraftForge.EVENT_BUS.post(new RenderPlayerEvent.Post(p_doRender_1_, this, p_doRender_9_, p_doRender_2_, p_doRender_4_, p_doRender_6_));
    }

    private void setModelVisibilities(AbstractClientPlayer p_setModelVisibilities_1_) {
        ModelPlayer modelplayer = this.getMainModel();
        if (p_setModelVisibilities_1_.isSpectator()) {
            modelplayer.setInvisible(false);
            modelplayer.bipedHead.showModel = true;
            modelplayer.bipedHeadwear.showModel = true;
        } else {
            ItemStack itemstack = p_setModelVisibilities_1_.getHeldItemMainhand();
            ItemStack itemstack1 = p_setModelVisibilities_1_.getHeldItemOffhand();
            modelplayer.setInvisible(true);
            modelplayer.bipedHeadwear.showModel = p_setModelVisibilities_1_.isWearing(EnumPlayerModelParts.HAT);
            modelplayer.bipedBodyWear.showModel = p_setModelVisibilities_1_.isWearing(EnumPlayerModelParts.JACKET);
            modelplayer.bipedLeftLegwear.showModel = p_setModelVisibilities_1_.isWearing(EnumPlayerModelParts.LEFT_PANTS_LEG);
            modelplayer.bipedRightLegwear.showModel = p_setModelVisibilities_1_.isWearing(EnumPlayerModelParts.RIGHT_PANTS_LEG);
            modelplayer.bipedLeftArmwear.showModel = p_setModelVisibilities_1_.isWearing(EnumPlayerModelParts.LEFT_SLEEVE);
            modelplayer.bipedRightArmwear.showModel = p_setModelVisibilities_1_.isWearing(EnumPlayerModelParts.RIGHT_SLEEVE);
            modelplayer.isSneak = p_setModelVisibilities_1_.isSneaking();
            ModelBiped.ArmPose modelbiped$armpose = ModelBiped.ArmPose.EMPTY;
            ModelBiped.ArmPose modelbiped$armpose1 = ModelBiped.ArmPose.EMPTY;
            if (!itemstack.isEmpty()) {
                modelbiped$armpose = ModelBiped.ArmPose.ITEM;
                if (p_setModelVisibilities_1_.getItemInUseCount() > 0) {
                    EnumAction enumaction = itemstack.getItemUseAction();
                    if (enumaction == EnumAction.BLOCK) {
                        modelbiped$armpose = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        modelbiped$armpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (!itemstack1.isEmpty()) {
                modelbiped$armpose1 = ModelBiped.ArmPose.ITEM;
                if (p_setModelVisibilities_1_.getItemInUseCount() > 0) {
                    EnumAction enumaction1 = itemstack1.getItemUseAction();
                    if (enumaction1 == EnumAction.BLOCK) {
                        modelbiped$armpose1 = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction1 == EnumAction.BOW) {
                        modelbiped$armpose1 = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (p_setModelVisibilities_1_.getPrimaryHand() == EnumHandSide.RIGHT) {
                modelplayer.rightArmPose = modelbiped$armpose;
                modelplayer.leftArmPose = modelbiped$armpose1;
            } else {
                modelplayer.rightArmPose = modelbiped$armpose1;
                modelplayer.leftArmPose = modelbiped$armpose;
            }
        }
    }

    @Override
    protected ResourceLocation getEntityTexture(AbstractClientPlayer p_getEntityTexture_1_) {
        return p_getEntityTexture_1_.getLocationSkin();
    }

    @Override
    public void transformHeldFull3DItemLayer() {
        GlStateManager.translate(0.0f, 0.1875f, 0.0f);
    }

    @Override
    protected void preRenderCallback(AbstractClientPlayer p_preRenderCallback_1_, float p_preRenderCallback_2_) {
        float f = 0.9375f;
        GlStateManager.scale(0.9375f, 0.9375f, 0.9375f);
    }

    @Override
    protected void renderEntityName(AbstractClientPlayer p_renderEntityName_1_, double p_renderEntityName_2_, double p_renderEntityName_4_, double p_renderEntityName_6_, String p_renderEntityName_8_, double p_renderEntityName_9_) {
        Scoreboard scoreboard;
        ScoreObjective scoreobjective;
        if (p_renderEntityName_9_ < 100.0 && (scoreobjective = (scoreboard = p_renderEntityName_1_.getWorldScoreboard()).getObjectiveInDisplaySlot(2)) != null) {
            Score score = scoreboard.getOrCreateScore(p_renderEntityName_1_.getName(), scoreobjective);
            this.renderLivingLabel(p_renderEntityName_1_, score.getScorePoints() + " " + scoreobjective.getDisplayName(), p_renderEntityName_2_, p_renderEntityName_4_, p_renderEntityName_6_, 64);
            p_renderEntityName_4_ += (double)((float)this.getFontRendererFromRenderManager().FONT_HEIGHT * 1.15f * 0.025f);
        }
        super.renderEntityName(p_renderEntityName_1_, p_renderEntityName_2_, p_renderEntityName_4_, p_renderEntityName_6_, p_renderEntityName_8_, p_renderEntityName_9_);
    }

    public void renderRightArm(AbstractClientPlayer p_renderRightArm_1_) {
        float f = 1.0f;
        GlStateManager.color(1.0f, 1.0f, 1.0f);
        float f1 = 0.0625f;
        ModelPlayer modelplayer = this.getMainModel();
        this.setModelVisibilities(p_renderRightArm_1_);
        GlStateManager.enableBlend();
        modelplayer.swingProgress = 0.0f;
        modelplayer.isSneak = false;
        modelplayer.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, p_renderRightArm_1_);
        modelplayer.bipedRightArm.rotateAngleX = 0.0f;
        modelplayer.bipedRightArm.render(0.0625f);
        modelplayer.bipedRightArmwear.rotateAngleX = 0.0f;
        modelplayer.bipedRightArmwear.render(0.0625f);
        GlStateManager.disableBlend();
    }

    public void renderLeftArm(AbstractClientPlayer p_renderLeftArm_1_) {
        float f = 1.0f;
        GlStateManager.color(1.0f, 1.0f, 1.0f);
        float f1 = 0.0625f;
        ModelPlayer modelplayer = this.getMainModel();
        this.setModelVisibilities(p_renderLeftArm_1_);
        GlStateManager.enableBlend();
        modelplayer.isSneak = false;
        modelplayer.swingProgress = 0.0f;
        modelplayer.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, p_renderLeftArm_1_);
        modelplayer.bipedLeftArm.rotateAngleX = 0.0f;
        modelplayer.bipedLeftArm.render(0.0625f);
        modelplayer.bipedLeftArmwear.rotateAngleX = 0.0f;
        modelplayer.bipedLeftArmwear.render(0.0625f);
        GlStateManager.disableBlend();
    }

    @Override
    protected void renderLivingAt(AbstractClientPlayer p_renderLivingAt_1_, double p_renderLivingAt_2_, double p_renderLivingAt_4_, double p_renderLivingAt_6_) {
        if (p_renderLivingAt_1_.isEntityAlive() && p_renderLivingAt_1_.isPlayerSleeping()) {
            super.renderLivingAt(p_renderLivingAt_1_, p_renderLivingAt_2_ + (double)p_renderLivingAt_1_.renderOffsetX, p_renderLivingAt_4_ + (double)p_renderLivingAt_1_.renderOffsetY, p_renderLivingAt_6_ + (double)p_renderLivingAt_1_.renderOffsetZ);
        } else {
            super.renderLivingAt(p_renderLivingAt_1_, p_renderLivingAt_2_, p_renderLivingAt_4_, p_renderLivingAt_6_);
        }
    }

    @Override
    protected void applyRotations(AbstractClientPlayer p_applyRotations_1_, float p_applyRotations_2_, float p_applyRotations_3_, float p_applyRotations_4_) {
        if (p_applyRotations_1_.isEntityAlive() && p_applyRotations_1_.isPlayerSleeping()) {
            GlStateManager.rotate(p_applyRotations_1_.getBedOrientationInDegrees(), 0.0f, 1.0f, 0.0f);
            GlStateManager.rotate(this.getDeathMaxRotation(p_applyRotations_1_), 0.0f, 0.0f, 1.0f);
            GlStateManager.rotate(270.0f, 0.0f, 1.0f, 0.0f);
        } else if (p_applyRotations_1_.isElytraFlying()) {
            super.applyRotations(p_applyRotations_1_, p_applyRotations_2_, p_applyRotations_3_, p_applyRotations_4_);
            float f = (float)p_applyRotations_1_.getTicksElytraFlying() + p_applyRotations_4_;
            float f1 = MathHelper.clamp(f * f / 100.0f, 0.0f, 1.0f);
            GlStateManager.rotate(f1 * (-90.0f - p_applyRotations_1_.rotationPitch), 1.0f, 0.0f, 0.0f);
            Vec3d vec3d = p_applyRotations_1_.getLook(p_applyRotations_4_);
            double d0 = p_applyRotations_1_.motionX * p_applyRotations_1_.motionX + p_applyRotations_1_.motionZ * p_applyRotations_1_.motionZ;
            double d1 = vec3d.xCoord * vec3d.xCoord + vec3d.zCoord * vec3d.zCoord;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (p_applyRotations_1_.motionX * vec3d.xCoord + p_applyRotations_1_.motionZ * vec3d.zCoord) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = p_applyRotations_1_.motionX * vec3d.zCoord - p_applyRotations_1_.motionZ * vec3d.xCoord;
                GlStateManager.rotate((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI, 0.0f, 1.0f, 0.0f);
            }
        } else {
            super.applyRotations(p_applyRotations_1_, p_applyRotations_2_, p_applyRotations_3_, p_applyRotations_4_);
        }
    }
}

