/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelShulker;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderShulker
extends RenderLiving<EntityShulker> {
    public static final ResourceLocation[] SHULKER_ENDERGOLEM_TEXTURE = new ResourceLocation[]{new ResourceLocation("textures/entity/shulker/shulker_white.png"), new ResourceLocation("textures/entity/shulker/shulker_orange.png"), new ResourceLocation("textures/entity/shulker/shulker_magenta.png"), new ResourceLocation("textures/entity/shulker/shulker_light_blue.png"), new ResourceLocation("textures/entity/shulker/shulker_yellow.png"), new ResourceLocation("textures/entity/shulker/shulker_lime.png"), new ResourceLocation("textures/entity/shulker/shulker_pink.png"), new ResourceLocation("textures/entity/shulker/shulker_gray.png"), new ResourceLocation("textures/entity/shulker/shulker_silver.png"), new ResourceLocation("textures/entity/shulker/shulker_cyan.png"), new ResourceLocation("textures/entity/shulker/shulker_purple.png"), new ResourceLocation("textures/entity/shulker/shulker_blue.png"), new ResourceLocation("textures/entity/shulker/shulker_brown.png"), new ResourceLocation("textures/entity/shulker/shulker_green.png"), new ResourceLocation("textures/entity/shulker/shulker_red.png"), new ResourceLocation("textures/entity/shulker/shulker_black.png")};

    public RenderShulker(RenderManager p_i47194_1_) {
        super(p_i47194_1_, new ModelShulker(), 0.0f);
        this.addLayer(new HeadLayer());
    }

    @Override
    public ModelShulker getMainModel() {
        return (ModelShulker)super.getMainModel();
    }

    @Override
    public void doRender(EntityShulker p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        int lvt_10_1_ = p_doRender_1_.getClientTeleportInterp();
        if (lvt_10_1_ > 0 && p_doRender_1_.isAttachedToBlock()) {
            BlockPos lvt_11_1_ = p_doRender_1_.getAttachmentPos();
            BlockPos lvt_12_1_ = p_doRender_1_.getOldAttachPos();
            double lvt_13_1_ = (double)((float)lvt_10_1_ - p_doRender_9_) / 6.0;
            lvt_13_1_ *= lvt_13_1_;
            double lvt_15_1_ = (double)(lvt_11_1_.getX() - lvt_12_1_.getX()) * lvt_13_1_;
            double lvt_17_1_ = (double)(lvt_11_1_.getY() - lvt_12_1_.getY()) * lvt_13_1_;
            double lvt_19_1_ = (double)(lvt_11_1_.getZ() - lvt_12_1_.getZ()) * lvt_13_1_;
            super.doRender(p_doRender_1_, p_doRender_2_ - lvt_15_1_, p_doRender_4_ - lvt_17_1_, p_doRender_6_ - lvt_19_1_, p_doRender_8_, p_doRender_9_);
        } else {
            super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
        }
    }

    @Override
    public boolean shouldRender(EntityShulker p_shouldRender_1_, ICamera p_shouldRender_2_, double p_shouldRender_3_, double p_shouldRender_5_, double p_shouldRender_7_) {
        if (super.shouldRender(p_shouldRender_1_, p_shouldRender_2_, p_shouldRender_3_, p_shouldRender_5_, p_shouldRender_7_)) {
            return true;
        }
        if (p_shouldRender_1_.getClientTeleportInterp() > 0 && p_shouldRender_1_.isAttachedToBlock()) {
            BlockPos lvt_9_1_ = p_shouldRender_1_.getOldAttachPos();
            BlockPos lvt_10_1_ = p_shouldRender_1_.getAttachmentPos();
            Vec3d lvt_11_1_ = new Vec3d(lvt_10_1_.getX(), lvt_10_1_.getY(), lvt_10_1_.getZ());
            Vec3d lvt_12_1_ = new Vec3d(lvt_9_1_.getX(), lvt_9_1_.getY(), lvt_9_1_.getZ());
            if (p_shouldRender_2_.isBoundingBoxInFrustum(new AxisAlignedBB(lvt_12_1_.xCoord, lvt_12_1_.yCoord, lvt_12_1_.zCoord, lvt_11_1_.xCoord, lvt_11_1_.yCoord, lvt_11_1_.zCoord))) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityShulker p_getEntityTexture_1_) {
        return SHULKER_ENDERGOLEM_TEXTURE[p_getEntityTexture_1_.getColor().getMetadata()];
    }

    @Override
    protected void applyRotations(EntityShulker p_applyRotations_1_, float p_applyRotations_2_, float p_applyRotations_3_, float p_applyRotations_4_) {
        super.applyRotations(p_applyRotations_1_, p_applyRotations_2_, p_applyRotations_3_, p_applyRotations_4_);
        switch (p_applyRotations_1_.getAttachmentFacing()) {
            case DOWN: {
                break;
            }
            case EAST: {
                GlStateManager.translate(0.5f, 0.5f, 0.0f);
                GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                GlStateManager.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                GlStateManager.translate(-0.5f, 0.5f, 0.0f);
                GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                GlStateManager.rotate(-90.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case NORTH: {
                GlStateManager.translate(0.0f, 0.5f, -0.5f);
                GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.translate(0.0f, 0.5f, 0.5f);
                GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                GlStateManager.rotate(180.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case UP: {
                GlStateManager.translate(0.0f, 1.0f, 0.0f);
                GlStateManager.rotate(180.0f, 1.0f, 0.0f, 0.0f);
            }
        }
    }

    @Override
    protected void preRenderCallback(EntityShulker p_preRenderCallback_1_, float p_preRenderCallback_2_) {
        float lvt_3_1_ = 0.999f;
        GlStateManager.scale(0.999f, 0.999f, 0.999f);
    }

    @Override
    public /* synthetic */ ModelBase getMainModel() {
        return this.getMainModel();
    }

    @SideOnly(value=Side.CLIENT)
    class HeadLayer
    implements LayerRenderer<EntityShulker> {
        private HeadLayer() {
        }

        @Override
        public void doRenderLayer(EntityShulker p_doRenderLayer_1_, float p_doRenderLayer_2_, float p_doRenderLayer_3_, float p_doRenderLayer_4_, float p_doRenderLayer_5_, float p_doRenderLayer_6_, float p_doRenderLayer_7_, float p_doRenderLayer_8_) {
            GlStateManager.pushMatrix();
            switch (p_doRenderLayer_1_.getAttachmentFacing()) {
                case DOWN: {
                    break;
                }
                case EAST: {
                    GlStateManager.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                    GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                    GlStateManager.translate(1.0f, -1.0f, 0.0f);
                    GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.rotate(-90.0f, 0.0f, 0.0f, 1.0f);
                    GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                    GlStateManager.translate(-1.0f, -1.0f, 0.0f);
                    GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                    break;
                }
                case NORTH: {
                    GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                    GlStateManager.translate(0.0f, -1.0f, -1.0f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.rotate(180.0f, 0.0f, 0.0f, 1.0f);
                    GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                    GlStateManager.translate(0.0f, -1.0f, 1.0f);
                    break;
                }
                case UP: {
                    GlStateManager.rotate(180.0f, 1.0f, 0.0f, 0.0f);
                    GlStateManager.translate(0.0f, -2.0f, 0.0f);
                }
            }
            ModelRenderer lvt_9_1_ = RenderShulker.this.getMainModel().head;
            lvt_9_1_.rotateAngleY = p_doRenderLayer_6_ * ((float)Math.PI / 180);
            lvt_9_1_.rotateAngleX = p_doRenderLayer_7_ * ((float)Math.PI / 180);
            RenderShulker.this.bindTexture(SHULKER_ENDERGOLEM_TEXTURE[p_doRenderLayer_1_.getColor().getMetadata()]);
            lvt_9_1_.render(p_doRenderLayer_8_);
            GlStateManager.popMatrix();
        }

        @Override
        public boolean shouldCombineTextures() {
            return false;
        }
    }
}

