/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelShulkerBullet;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderShulkerBullet
extends Render<EntityShulkerBullet> {
    private static final ResourceLocation SHULKER_SPARK_TEXTURE = new ResourceLocation("textures/entity/shulker/spark.png");
    private final ModelShulkerBullet model = new ModelShulkerBullet();

    public RenderShulkerBullet(RenderManager p_i46551_1_) {
        super(p_i46551_1_);
    }

    private float rotLerp(float p_rotLerp_1_, float p_rotLerp_2_, float p_rotLerp_3_) {
        float lvt_4_1_;
        for (lvt_4_1_ = p_rotLerp_2_ - p_rotLerp_1_; lvt_4_1_ < -180.0f; lvt_4_1_ += 360.0f) {
        }
        while (lvt_4_1_ >= 180.0f) {
            lvt_4_1_ -= 360.0f;
        }
        return p_rotLerp_1_ + p_rotLerp_3_ * lvt_4_1_;
    }

    @Override
    public void doRender(EntityShulkerBullet p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        GlStateManager.pushMatrix();
        float lvt_10_1_ = this.rotLerp(p_doRender_1_.prevRotationYaw, p_doRender_1_.rotationYaw, p_doRender_9_);
        float lvt_11_1_ = p_doRender_1_.prevRotationPitch + (p_doRender_1_.rotationPitch - p_doRender_1_.prevRotationPitch) * p_doRender_9_;
        float lvt_12_1_ = (float)p_doRender_1_.ticksExisted + p_doRender_9_;
        GlStateManager.translate((float)p_doRender_2_, (float)p_doRender_4_ + 0.15f, (float)p_doRender_6_);
        GlStateManager.rotate(MathHelper.sin(lvt_12_1_ * 0.1f) * 180.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(MathHelper.cos(lvt_12_1_ * 0.1f) * 180.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(MathHelper.sin(lvt_12_1_ * 0.15f) * 360.0f, 0.0f, 0.0f, 1.0f);
        float lvt_13_1_ = 0.03125f;
        GlStateManager.enableRescaleNormal();
        GlStateManager.scale(-1.0f, -1.0f, 1.0f);
        this.bindEntityTexture(p_doRender_1_);
        this.model.render(p_doRender_1_, 0.0f, 0.0f, 0.0f, lvt_10_1_, lvt_11_1_, 0.03125f);
        GlStateManager.enableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 0.5f);
        GlStateManager.scale(1.5f, 1.5f, 1.5f);
        this.model.render(p_doRender_1_, 0.0f, 0.0f, 0.0f, lvt_10_1_, lvt_11_1_, 0.03125f);
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityShulkerBullet p_getEntityTexture_1_) {
        return SHULKER_SPARK_TEXTURE;
    }
}

