/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerSlimeGel;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSlime
extends RenderLiving<EntitySlime> {
    private static final ResourceLocation SLIME_TEXTURES = new ResourceLocation("textures/entity/slime/slime.png");

    public RenderSlime(RenderManager p_i47193_1_) {
        super(p_i47193_1_, new ModelSlime(16), 0.25f);
        this.addLayer(new LayerSlimeGel(this));
    }

    @Override
    public void doRender(EntitySlime p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        this.shadowSize = 0.25f * (float)p_doRender_1_.getSlimeSize();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected void preRenderCallback(EntitySlime p_preRenderCallback_1_, float p_preRenderCallback_2_) {
        float lvt_3_1_ = 0.999f;
        GlStateManager.scale(0.999f, 0.999f, 0.999f);
        float lvt_4_1_ = p_preRenderCallback_1_.getSlimeSize();
        float lvt_5_1_ = (p_preRenderCallback_1_.prevSquishFactor + (p_preRenderCallback_1_.squishFactor - p_preRenderCallback_1_.prevSquishFactor) * p_preRenderCallback_2_) / (lvt_4_1_ * 0.5f + 1.0f);
        float lvt_6_1_ = 1.0f / (lvt_5_1_ + 1.0f);
        GlStateManager.scale(lvt_6_1_ * lvt_4_1_, 1.0f / lvt_6_1_ * lvt_4_1_, lvt_6_1_ * lvt_4_1_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntitySlime p_getEntityTexture_1_) {
        return SLIME_TEXTURES;
    }
}

