/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSquid
extends RenderLiving<EntitySquid> {
    private static final ResourceLocation SQUID_TEXTURES = new ResourceLocation("textures/entity/squid.png");

    public RenderSquid(RenderManager p_i47192_1_) {
        super(p_i47192_1_, new ModelSquid(), 0.7f);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntitySquid p_getEntityTexture_1_) {
        return SQUID_TEXTURES;
    }

    @Override
    protected void applyRotations(EntitySquid p_applyRotations_1_, float p_applyRotations_2_, float p_applyRotations_3_, float p_applyRotations_4_) {
        float lvt_5_1_ = p_applyRotations_1_.prevSquidPitch + (p_applyRotations_1_.squidPitch - p_applyRotations_1_.prevSquidPitch) * p_applyRotations_4_;
        float lvt_6_1_ = p_applyRotations_1_.prevSquidYaw + (p_applyRotations_1_.squidYaw - p_applyRotations_1_.prevSquidYaw) * p_applyRotations_4_;
        GlStateManager.translate(0.0f, 0.5f, 0.0f);
        GlStateManager.rotate(180.0f - p_applyRotations_3_, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(lvt_5_1_, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(lvt_6_1_, 0.0f, 1.0f, 0.0f);
        GlStateManager.translate(0.0f, -1.2f, 0.0f);
    }

    @Override
    protected float handleRotationFloat(EntitySquid p_handleRotationFloat_1_, float p_handleRotationFloat_2_) {
        return p_handleRotationFloat_1_.lastTentacleAngle + (p_handleRotationFloat_1_.tentacleAngle - p_handleRotationFloat_1_.lastTentacleAngle) * p_handleRotationFloat_2_;
    }

    @Override
    protected /* synthetic */ float handleRotationFloat(EntityLivingBase p_handleRotationFloat_1_, float p_handleRotationFloat_2_) {
        return this.handleRotationFloat((EntitySquid)p_handleRotationFloat_1_, p_handleRotationFloat_2_);
    }
}

