/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelWither;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerWitherAura;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWither
extends RenderLiving<EntityWither> {
    private static final ResourceLocation INVULNERABLE_WITHER_TEXTURES = new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_TEXTURES = new ResourceLocation("textures/entity/wither/wither.png");

    public RenderWither(RenderManager p_i46130_1_) {
        super(p_i46130_1_, new ModelWither(0.0f), 1.0f);
        this.addLayer(new LayerWitherAura(this));
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityWither p_getEntityTexture_1_) {
        int lvt_2_1_ = p_getEntityTexture_1_.getInvulTime();
        if (lvt_2_1_ <= 0 || lvt_2_1_ <= 80 && lvt_2_1_ / 5 % 2 == 1) {
            return WITHER_TEXTURES;
        }
        return INVULNERABLE_WITHER_TEXTURES;
    }

    @Override
    protected void preRenderCallback(EntityWither p_preRenderCallback_1_, float p_preRenderCallback_2_) {
        float lvt_3_1_ = 2.0f;
        int lvt_4_1_ = p_preRenderCallback_1_.getInvulTime();
        if (lvt_4_1_ > 0) {
            lvt_3_1_ -= ((float)lvt_4_1_ - p_preRenderCallback_2_) / 220.0f * 0.5f;
        }
        GlStateManager.scale(lvt_3_1_, lvt_3_1_, lvt_3_1_);
    }
}

