/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerWolfCollar;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWolf
extends RenderLiving<EntityWolf> {
    private static final ResourceLocation WOLF_TEXTURES = new ResourceLocation("textures/entity/wolf/wolf.png");
    private static final ResourceLocation TAMED_WOLF_TEXTURES = new ResourceLocation("textures/entity/wolf/wolf_tame.png");
    private static final ResourceLocation ANRGY_WOLF_TEXTURES = new ResourceLocation("textures/entity/wolf/wolf_angry.png");

    public RenderWolf(RenderManager p_i47187_1_) {
        super(p_i47187_1_, new ModelWolf(), 0.5f);
        this.addLayer(new LayerWolfCollar(this));
    }

    @Override
    protected float handleRotationFloat(EntityWolf p_handleRotationFloat_1_, float p_handleRotationFloat_2_) {
        return p_handleRotationFloat_1_.getTailRotation();
    }

    @Override
    public void doRender(EntityWolf p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        if (p_doRender_1_.isWolfWet()) {
            float lvt_10_1_ = p_doRender_1_.getBrightness(p_doRender_9_) * p_doRender_1_.getShadingWhileWet(p_doRender_9_);
            GlStateManager.color(lvt_10_1_, lvt_10_1_, lvt_10_1_);
        }
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityWolf p_getEntityTexture_1_) {
        if (p_getEntityTexture_1_.isTamed()) {
            return TAMED_WOLF_TEXTURES;
        }
        if (p_getEntityTexture_1_.isAngry()) {
            return ANRGY_WOLF_TEXTURES;
        }
        return WOLF_TEXTURES;
    }

    @Override
    protected /* synthetic */ float handleRotationFloat(EntityLivingBase p_handleRotationFloat_1_, float p_handleRotationFloat_2_) {
        return this.handleRotationFloat((EntityWolf)p_handleRotationFloat_1_, p_handleRotationFloat_2_);
    }
}

