/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderXPOrb
extends Render<EntityXPOrb> {
    private static final ResourceLocation EXPERIENCE_ORB_TEXTURES = new ResourceLocation("textures/entity/experience_orb.png");

    public RenderXPOrb(RenderManager p_i46178_1_) {
        super(p_i46178_1_);
        this.shadowSize = 0.15f;
        this.shadowOpaque = 0.75f;
    }

    @Override
    public void doRender(EntityXPOrb p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        if (this.renderOutlines) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)p_doRender_2_, (float)p_doRender_4_, (float)p_doRender_6_);
        this.bindEntityTexture(p_doRender_1_);
        RenderHelper.enableStandardItemLighting();
        int lvt_10_1_ = p_doRender_1_.getTextureByXP();
        float lvt_11_1_ = (float)(lvt_10_1_ % 4 * 16 + 0) / 64.0f;
        float lvt_12_1_ = (float)(lvt_10_1_ % 4 * 16 + 16) / 64.0f;
        float lvt_13_1_ = (float)(lvt_10_1_ / 4 * 16 + 0) / 64.0f;
        float lvt_14_1_ = (float)(lvt_10_1_ / 4 * 16 + 16) / 64.0f;
        float lvt_15_1_ = 1.0f;
        float lvt_16_1_ = 0.5f;
        float lvt_17_1_ = 0.25f;
        int lvt_18_1_ = p_doRender_1_.getBrightnessForRender(p_doRender_9_);
        int lvt_19_1_ = lvt_18_1_ % 65536;
        int lvt_20_1_ = lvt_18_1_ / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, lvt_19_1_, lvt_20_1_);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        float lvt_18_2_ = 255.0f;
        float lvt_19_2_ = ((float)p_doRender_1_.xpColor + p_doRender_9_) / 2.0f;
        int lvt_20_2_ = (int)((MathHelper.sin(lvt_19_2_ + 0.0f) + 1.0f) * 0.5f * 255.0f);
        int lvt_21_1_ = 255;
        int lvt_22_1_ = (int)((MathHelper.sin(lvt_19_2_ + 4.1887903f) + 1.0f) * 0.1f * 255.0f);
        GlStateManager.translate(0.0f, 0.1f, 0.0f);
        GlStateManager.rotate(180.0f - this.renderManager.playerViewY, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate((float)(this.renderManager.options.thirdPersonView == 2 ? -1 : 1) * -this.renderManager.playerViewX, 1.0f, 0.0f, 0.0f);
        float lvt_23_1_ = 0.3f;
        GlStateManager.scale(0.3f, 0.3f, 0.3f);
        Tessellator lvt_24_1_ = Tessellator.getInstance();
        VertexBuffer lvt_25_1_ = lvt_24_1_.getBuffer();
        lvt_25_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL);
        lvt_25_1_.pos(-0.5, -0.25, 0.0).tex(lvt_11_1_, lvt_14_1_).color(lvt_20_2_, 255, lvt_22_1_, 128).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_25_1_.pos(0.5, -0.25, 0.0).tex(lvt_12_1_, lvt_14_1_).color(lvt_20_2_, 255, lvt_22_1_, 128).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_25_1_.pos(0.5, 0.75, 0.0).tex(lvt_12_1_, lvt_13_1_).color(lvt_20_2_, 255, lvt_22_1_, 128).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_25_1_.pos(-0.5, 0.75, 0.0).tex(lvt_11_1_, lvt_13_1_).color(lvt_20_2_, 255, lvt_22_1_, 128).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_24_1_.draw();
        GlStateManager.disableBlend();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityXPOrb p_getEntityTexture_1_) {
        return EXPERIENCE_ORB_TEXTURES;
    }
}

