/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelZombieVillager;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerVillagerArmor;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderZombieVillager
extends RenderBiped<EntityZombieVillager> {
    private static final ResourceLocation ZOMBIE_VILLAGER_TEXTURES = new ResourceLocation("textures/entity/zombie_villager/zombie_villager.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_FARMER_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_farmer.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_LIBRARIAN_LOC = new ResourceLocation("textures/entity/zombie_villager/zombie_librarian.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PRIEST_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_priest.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_SMITH_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_smith.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_BUTCHER_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_butcher.png");

    public RenderZombieVillager(RenderManager p_i47186_1_) {
        super(p_i47186_1_, new ModelZombieVillager(), 0.5f);
        this.addLayer(new LayerVillagerArmor(this));
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityZombieVillager p_getEntityTexture_1_) {
        switch (p_getEntityTexture_1_.getProfession()) {
            case 0: {
                return ZOMBIE_VILLAGER_FARMER_LOCATION;
            }
            case 1: {
                return ZOMBIE_VILLAGER_LIBRARIAN_LOC;
            }
            case 2: {
                return ZOMBIE_VILLAGER_PRIEST_LOCATION;
            }
            case 3: {
                return ZOMBIE_VILLAGER_SMITH_LOCATION;
            }
            case 4: {
                return ZOMBIE_VILLAGER_BUTCHER_LOCATION;
            }
        }
        return ZOMBIE_VILLAGER_TEXTURES;
    }

    @Override
    protected void applyRotations(EntityZombieVillager p_applyRotations_1_, float p_applyRotations_2_, float p_applyRotations_3_, float p_applyRotations_4_) {
        if (p_applyRotations_1_.isConverting()) {
            p_applyRotations_3_ += (float)(Math.cos((double)p_applyRotations_1_.ticksExisted * 3.25) * Math.PI * 0.25);
        }
        super.applyRotations(p_applyRotations_1_, p_applyRotations_2_, p_applyRotations_3_, p_applyRotations_4_);
    }
}

