/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class LayerArmorBase<T extends ModelBase>
implements LayerRenderer<EntityLivingBase> {
    protected static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected T modelLeggings;
    protected T modelArmor;
    private final RenderLivingBase<?> renderer;
    private float alpha = 1.0f;
    private float colorR = 1.0f;
    private float colorG = 1.0f;
    private float colorB = 1.0f;
    private boolean skipRenderGlint;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public LayerArmorBase(RenderLivingBase<?> p_i46125_1_) {
        this.renderer = p_i46125_1_;
        this.initArmor();
    }

    @Override
    public void doRenderLayer(EntityLivingBase p_doRenderLayer_1_, float p_doRenderLayer_2_, float p_doRenderLayer_3_, float p_doRenderLayer_4_, float p_doRenderLayer_5_, float p_doRenderLayer_6_, float p_doRenderLayer_7_, float p_doRenderLayer_8_) {
        this.renderArmorLayer(p_doRenderLayer_1_, p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_4_, p_doRenderLayer_5_, p_doRenderLayer_6_, p_doRenderLayer_7_, p_doRenderLayer_8_, EntityEquipmentSlot.CHEST);
        this.renderArmorLayer(p_doRenderLayer_1_, p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_4_, p_doRenderLayer_5_, p_doRenderLayer_6_, p_doRenderLayer_7_, p_doRenderLayer_8_, EntityEquipmentSlot.LEGS);
        this.renderArmorLayer(p_doRenderLayer_1_, p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_4_, p_doRenderLayer_5_, p_doRenderLayer_6_, p_doRenderLayer_7_, p_doRenderLayer_8_, EntityEquipmentSlot.FEET);
        this.renderArmorLayer(p_doRenderLayer_1_, p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_4_, p_doRenderLayer_5_, p_doRenderLayer_6_, p_doRenderLayer_7_, p_doRenderLayer_8_, EntityEquipmentSlot.HEAD);
    }

    @Override
    public boolean shouldCombineTextures() {
        return false;
    }

    private void renderArmorLayer(EntityLivingBase p_renderArmorLayer_1_, float p_renderArmorLayer_2_, float p_renderArmorLayer_3_, float p_renderArmorLayer_4_, float p_renderArmorLayer_5_, float p_renderArmorLayer_6_, float p_renderArmorLayer_7_, float p_renderArmorLayer_8_, EntityEquipmentSlot p_renderArmorLayer_9_) {
        ItemArmor itemarmor;
        ItemStack itemstack = p_renderArmorLayer_1_.getItemStackFromSlot(p_renderArmorLayer_9_);
        if (itemstack.getItem() instanceof ItemArmor && (itemarmor = (ItemArmor)itemstack.getItem()).getEquipmentSlot() == p_renderArmorLayer_9_) {
            T t = this.getModelFromSlot(p_renderArmorLayer_9_);
            t = this.getArmorModelHook(p_renderArmorLayer_1_, itemstack, p_renderArmorLayer_9_, t);
            ((ModelBase)t).setModelAttributes(this.renderer.getMainModel());
            ((ModelBase)t).setLivingAnimations(p_renderArmorLayer_1_, p_renderArmorLayer_2_, p_renderArmorLayer_3_, p_renderArmorLayer_4_);
            this.setModelSlotVisible(t, p_renderArmorLayer_9_);
            boolean flag = this.isLegSlot(p_renderArmorLayer_9_);
            this.renderer.bindTexture(this.getArmorResource(p_renderArmorLayer_1_, itemstack, p_renderArmorLayer_9_, null));
            if (itemarmor.hasOverlay(itemstack)) {
                int i = itemarmor.getColor(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GlStateManager.color(this.colorR * f, this.colorG * f1, this.colorB * f2, this.alpha);
                ((ModelBase)t).render(p_renderArmorLayer_1_, p_renderArmorLayer_2_, p_renderArmorLayer_3_, p_renderArmorLayer_5_, p_renderArmorLayer_6_, p_renderArmorLayer_7_, p_renderArmorLayer_8_);
                this.renderer.bindTexture(this.getArmorResource(p_renderArmorLayer_1_, itemstack, p_renderArmorLayer_9_, "overlay"));
            }
            GlStateManager.color(this.colorR, this.colorG, this.colorB, this.alpha);
            ((ModelBase)t).render(p_renderArmorLayer_1_, p_renderArmorLayer_2_, p_renderArmorLayer_3_, p_renderArmorLayer_5_, p_renderArmorLayer_6_, p_renderArmorLayer_7_, p_renderArmorLayer_8_);
            if (!this.skipRenderGlint && itemstack.hasEffect()) {
                LayerArmorBase.renderEnchantedGlint(this.renderer, p_renderArmorLayer_1_, t, p_renderArmorLayer_2_, p_renderArmorLayer_3_, p_renderArmorLayer_4_, p_renderArmorLayer_5_, p_renderArmorLayer_6_, p_renderArmorLayer_7_, p_renderArmorLayer_8_);
            }
        }
    }

    public T getModelFromSlot(EntityEquipmentSlot p_getModelFromSlot_1_) {
        return this.isLegSlot(p_getModelFromSlot_1_) ? this.modelLeggings : this.modelArmor;
    }

    private boolean isLegSlot(EntityEquipmentSlot p_isLegSlot_1_) {
        return p_isLegSlot_1_ == EntityEquipmentSlot.LEGS;
    }

    public static void renderEnchantedGlint(RenderLivingBase<?> p_renderEnchantedGlint_0_, EntityLivingBase p_renderEnchantedGlint_1_, ModelBase p_renderEnchantedGlint_2_, float p_renderEnchantedGlint_3_, float p_renderEnchantedGlint_4_, float p_renderEnchantedGlint_5_, float p_renderEnchantedGlint_6_, float p_renderEnchantedGlint_7_, float p_renderEnchantedGlint_8_, float p_renderEnchantedGlint_9_) {
        float f = (float)p_renderEnchantedGlint_1_.ticksExisted + p_renderEnchantedGlint_5_;
        p_renderEnchantedGlint_0_.bindTexture(ENCHANTED_ITEM_GLINT_RES);
        Minecraft.getMinecraft().entityRenderer.func_191514_d(true);
        GlStateManager.enableBlend();
        GlStateManager.depthFunc(514);
        GlStateManager.depthMask(false);
        float f1 = 0.5f;
        GlStateManager.color(0.5f, 0.5f, 0.5f, 1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.disableLighting();
            GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_COLOR, GlStateManager.DestFactor.ONE);
            float f2 = 0.76f;
            GlStateManager.color(0.38f, 0.19f, 0.608f, 1.0f);
            GlStateManager.matrixMode(5890);
            GlStateManager.loadIdentity();
            float f3 = 0.33333334f;
            GlStateManager.scale(0.33333334f, 0.33333334f, 0.33333334f);
            GlStateManager.rotate(30.0f - (float)i * 60.0f, 0.0f, 0.0f, 1.0f);
            GlStateManager.translate(0.0f, f * (0.001f + (float)i * 0.003f) * 20.0f, 0.0f);
            GlStateManager.matrixMode(5888);
            p_renderEnchantedGlint_2_.render(p_renderEnchantedGlint_1_, p_renderEnchantedGlint_3_, p_renderEnchantedGlint_4_, p_renderEnchantedGlint_6_, p_renderEnchantedGlint_7_, p_renderEnchantedGlint_8_, p_renderEnchantedGlint_9_);
            GlStateManager.blendFunc(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.matrixMode(5890);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode(5888);
        GlStateManager.enableLighting();
        GlStateManager.depthMask(true);
        GlStateManager.depthFunc(515);
        GlStateManager.disableBlend();
        Minecraft.getMinecraft().entityRenderer.func_191514_d(false);
    }

    @Deprecated
    private ResourceLocation getArmorResource(ItemArmor p_getArmorResource_1_, boolean p_getArmorResource_2_) {
        return this.getArmorResource(p_getArmorResource_1_, p_getArmorResource_2_, null);
    }

    @Deprecated
    private ResourceLocation getArmorResource(ItemArmor p_getArmorResource_1_, boolean p_getArmorResource_2_, String p_getArmorResource_3_) {
        String s = String.format("textures/models/armor/%s_layer_%d%s.png", p_getArmorResource_1_.getArmorMaterial().getName(), p_getArmorResource_2_ ? 2 : 1, p_getArmorResource_3_ == null ? "" : String.format("_%s", p_getArmorResource_3_));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            ARMOR_TEXTURE_RES_MAP.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    protected abstract void initArmor();

    protected abstract void setModelSlotVisible(T var1, EntityEquipmentSlot var2);

    protected T getArmorModelHook(EntityLivingBase p_getArmorModelHook_1_, ItemStack p_getArmorModelHook_2_, EntityEquipmentSlot p_getArmorModelHook_3_, T p_getArmorModelHook_4_) {
        return p_getArmorModelHook_4_;
    }

    public ResourceLocation getArmorResource(Entity p_getArmorResource_1_, ItemStack p_getArmorResource_2_, EntityEquipmentSlot p_getArmorResource_3_, String p_getArmorResource_4_) {
        ItemArmor item = (ItemArmor)p_getArmorResource_2_.getItem();
        String texture = item.getArmorMaterial().getName();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.isLegSlot(p_getArmorResource_3_) ? 2 : 1, p_getArmorResource_4_ == null ? "" : String.format("_%s", p_getArmorResource_4_));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture(p_getArmorResource_1_, p_getArmorResource_2_, s1, p_getArmorResource_3_, p_getArmorResource_4_));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

