/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import java.util.Random;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerArrow
implements LayerRenderer<EntityLivingBase> {
    private final RenderLivingBase<?> renderer;

    public LayerArrow(RenderLivingBase<?> p_i46124_1_) {
        this.renderer = p_i46124_1_;
    }

    @Override
    public void doRenderLayer(EntityLivingBase p_doRenderLayer_1_, float p_doRenderLayer_2_, float p_doRenderLayer_3_, float p_doRenderLayer_4_, float p_doRenderLayer_5_, float p_doRenderLayer_6_, float p_doRenderLayer_7_, float p_doRenderLayer_8_) {
        int lvt_9_1_ = p_doRenderLayer_1_.getArrowCountInEntity();
        if (lvt_9_1_ <= 0) {
            return;
        }
        EntityTippedArrow lvt_10_1_ = new EntityTippedArrow(p_doRenderLayer_1_.world, p_doRenderLayer_1_.posX, p_doRenderLayer_1_.posY, p_doRenderLayer_1_.posZ);
        Random lvt_11_1_ = new Random(p_doRenderLayer_1_.getEntityId());
        RenderHelper.disableStandardItemLighting();
        for (int lvt_12_1_ = 0; lvt_12_1_ < lvt_9_1_; ++lvt_12_1_) {
            GlStateManager.pushMatrix();
            ModelRenderer lvt_13_1_ = this.renderer.getMainModel().getRandomModelBox(lvt_11_1_);
            ModelBox lvt_14_1_ = lvt_13_1_.cubeList.get(lvt_11_1_.nextInt(lvt_13_1_.cubeList.size()));
            lvt_13_1_.postRender(0.0625f);
            float lvt_15_1_ = lvt_11_1_.nextFloat();
            float lvt_16_1_ = lvt_11_1_.nextFloat();
            float lvt_17_1_ = lvt_11_1_.nextFloat();
            float lvt_18_1_ = (lvt_14_1_.posX1 + (lvt_14_1_.posX2 - lvt_14_1_.posX1) * lvt_15_1_) / 16.0f;
            float lvt_19_1_ = (lvt_14_1_.posY1 + (lvt_14_1_.posY2 - lvt_14_1_.posY1) * lvt_16_1_) / 16.0f;
            float lvt_20_1_ = (lvt_14_1_.posZ1 + (lvt_14_1_.posZ2 - lvt_14_1_.posZ1) * lvt_17_1_) / 16.0f;
            GlStateManager.translate(lvt_18_1_, lvt_19_1_, lvt_20_1_);
            lvt_15_1_ = lvt_15_1_ * 2.0f - 1.0f;
            lvt_16_1_ = lvt_16_1_ * 2.0f - 1.0f;
            lvt_17_1_ = lvt_17_1_ * 2.0f - 1.0f;
            float lvt_21_1_ = MathHelper.sqrt((lvt_15_1_ *= -1.0f) * lvt_15_1_ + (lvt_17_1_ *= -1.0f) * lvt_17_1_);
            lvt_10_1_.rotationYaw = (float)(Math.atan2(lvt_15_1_, lvt_17_1_) * 57.2957763671875);
            lvt_10_1_.rotationPitch = (float)(Math.atan2(lvt_16_1_ *= -1.0f, lvt_21_1_) * 57.2957763671875);
            lvt_10_1_.prevRotationYaw = lvt_10_1_.rotationYaw;
            lvt_10_1_.prevRotationPitch = lvt_10_1_.rotationPitch;
            double lvt_22_1_ = 0.0;
            double lvt_24_1_ = 0.0;
            double lvt_26_1_ = 0.0;
            this.renderer.getRenderManager().doRenderEntity(lvt_10_1_, 0.0, 0.0, 0.0, 0.0f, p_doRenderLayer_4_, false);
            GlStateManager.popMatrix();
        }
        RenderHelper.enableStandardItemLighting();
    }

    @Override
    public boolean shouldCombineTextures() {
        return false;
    }
}

