/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerCape
implements LayerRenderer<AbstractClientPlayer> {
    private final RenderPlayer playerRenderer;

    public LayerCape(RenderPlayer p_i46123_1_) {
        this.playerRenderer = p_i46123_1_;
    }

    @Override
    public void doRenderLayer(AbstractClientPlayer p_doRenderLayer_1_, float p_doRenderLayer_2_, float p_doRenderLayer_3_, float p_doRenderLayer_4_, float p_doRenderLayer_5_, float p_doRenderLayer_6_, float p_doRenderLayer_7_, float p_doRenderLayer_8_) {
        if (!p_doRenderLayer_1_.hasPlayerInfo() || p_doRenderLayer_1_.isInvisible() || !p_doRenderLayer_1_.isWearing(EnumPlayerModelParts.CAPE) || p_doRenderLayer_1_.getLocationCape() == null) {
            return;
        }
        ItemStack lvt_9_1_ = p_doRenderLayer_1_.getItemStackFromSlot(EntityEquipmentSlot.CHEST);
        if (lvt_9_1_.getItem() == Items.ELYTRA) {
            return;
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.playerRenderer.bindTexture(p_doRenderLayer_1_.getLocationCape());
        GlStateManager.pushMatrix();
        GlStateManager.translate(0.0f, 0.0f, 0.125f);
        double lvt_10_1_ = p_doRenderLayer_1_.prevChasingPosX + (p_doRenderLayer_1_.chasingPosX - p_doRenderLayer_1_.prevChasingPosX) * (double)p_doRenderLayer_4_ - (p_doRenderLayer_1_.prevPosX + (p_doRenderLayer_1_.posX - p_doRenderLayer_1_.prevPosX) * (double)p_doRenderLayer_4_);
        double lvt_12_1_ = p_doRenderLayer_1_.prevChasingPosY + (p_doRenderLayer_1_.chasingPosY - p_doRenderLayer_1_.prevChasingPosY) * (double)p_doRenderLayer_4_ - (p_doRenderLayer_1_.prevPosY + (p_doRenderLayer_1_.posY - p_doRenderLayer_1_.prevPosY) * (double)p_doRenderLayer_4_);
        double lvt_14_1_ = p_doRenderLayer_1_.prevChasingPosZ + (p_doRenderLayer_1_.chasingPosZ - p_doRenderLayer_1_.prevChasingPosZ) * (double)p_doRenderLayer_4_ - (p_doRenderLayer_1_.prevPosZ + (p_doRenderLayer_1_.posZ - p_doRenderLayer_1_.prevPosZ) * (double)p_doRenderLayer_4_);
        float lvt_16_1_ = p_doRenderLayer_1_.prevRenderYawOffset + (p_doRenderLayer_1_.renderYawOffset - p_doRenderLayer_1_.prevRenderYawOffset) * p_doRenderLayer_4_;
        double lvt_17_1_ = MathHelper.sin(lvt_16_1_ * ((float)Math.PI / 180));
        double lvt_19_1_ = -MathHelper.cos(lvt_16_1_ * ((float)Math.PI / 180));
        float lvt_21_1_ = (float)lvt_12_1_ * 10.0f;
        lvt_21_1_ = MathHelper.clamp(lvt_21_1_, -6.0f, 32.0f);
        float lvt_22_1_ = (float)(lvt_10_1_ * lvt_17_1_ + lvt_14_1_ * lvt_19_1_) * 100.0f;
        float lvt_23_1_ = (float)(lvt_10_1_ * lvt_19_1_ - lvt_14_1_ * lvt_17_1_) * 100.0f;
        if (lvt_22_1_ < 0.0f) {
            lvt_22_1_ = 0.0f;
        }
        float lvt_24_1_ = p_doRenderLayer_1_.prevCameraYaw + (p_doRenderLayer_1_.cameraYaw - p_doRenderLayer_1_.prevCameraYaw) * p_doRenderLayer_4_;
        lvt_21_1_ += MathHelper.sin((p_doRenderLayer_1_.prevDistanceWalkedModified + (p_doRenderLayer_1_.distanceWalkedModified - p_doRenderLayer_1_.prevDistanceWalkedModified) * p_doRenderLayer_4_) * 6.0f) * 32.0f * lvt_24_1_;
        if (p_doRenderLayer_1_.isSneaking()) {
            lvt_21_1_ += 25.0f;
        }
        GlStateManager.rotate(6.0f + lvt_22_1_ / 2.0f + lvt_21_1_, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(lvt_23_1_ / 2.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.rotate(-lvt_23_1_ / 2.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        this.playerRenderer.getMainModel().renderCape(0.0625f);
        GlStateManager.popMatrix();
    }

    @Override
    public boolean shouldCombineTextures() {
        return false;
    }
}

