/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelElytra;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerElytra
implements LayerRenderer<EntityLivingBase> {
    private static final ResourceLocation TEXTURE_ELYTRA = new ResourceLocation("textures/entity/elytra.png");
    protected final RenderLivingBase<?> renderPlayer;
    private final ModelElytra modelElytra = new ModelElytra();

    public LayerElytra(RenderLivingBase<?> p_i47185_1_) {
        this.renderPlayer = p_i47185_1_;
    }

    @Override
    public void doRenderLayer(EntityLivingBase p_doRenderLayer_1_, float p_doRenderLayer_2_, float p_doRenderLayer_3_, float p_doRenderLayer_4_, float p_doRenderLayer_5_, float p_doRenderLayer_6_, float p_doRenderLayer_7_, float p_doRenderLayer_8_) {
        ItemStack lvt_9_1_ = p_doRenderLayer_1_.getItemStackFromSlot(EntityEquipmentSlot.CHEST);
        if (lvt_9_1_.getItem() != Items.ELYTRA) {
            return;
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        if (p_doRenderLayer_1_ instanceof AbstractClientPlayer) {
            AbstractClientPlayer lvt_10_1_ = (AbstractClientPlayer)p_doRenderLayer_1_;
            if (lvt_10_1_.isPlayerInfoSet() && lvt_10_1_.getLocationElytra() != null) {
                this.renderPlayer.bindTexture(lvt_10_1_.getLocationElytra());
            } else if (lvt_10_1_.hasPlayerInfo() && lvt_10_1_.getLocationCape() != null && lvt_10_1_.isWearing(EnumPlayerModelParts.CAPE)) {
                this.renderPlayer.bindTexture(lvt_10_1_.getLocationCape());
            } else {
                this.renderPlayer.bindTexture(TEXTURE_ELYTRA);
            }
        } else {
            this.renderPlayer.bindTexture(TEXTURE_ELYTRA);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate(0.0f, 0.0f, 0.125f);
        this.modelElytra.setRotationAngles(p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_5_, p_doRenderLayer_6_, p_doRenderLayer_7_, p_doRenderLayer_8_, p_doRenderLayer_1_);
        this.modelElytra.render(p_doRenderLayer_1_, p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_5_, p_doRenderLayer_6_, p_doRenderLayer_7_, p_doRenderLayer_8_);
        if (lvt_9_1_.isItemEnchanted()) {
            LayerArmorBase.renderEnchantedGlint(this.renderPlayer, p_doRenderLayer_1_, this.modelElytra, p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_4_, p_doRenderLayer_5_, p_doRenderLayer_6_, p_doRenderLayer_7_, p_doRenderLayer_8_);
        }
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    @Override
    public boolean shouldCombineTextures() {
        return false;
    }
}

