/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerHeldItem
implements LayerRenderer<EntityLivingBase> {
    protected final RenderLivingBase<?> livingEntityRenderer;

    public LayerHeldItem(RenderLivingBase<?> p_i46115_1_) {
        this.livingEntityRenderer = p_i46115_1_;
    }

    @Override
    public void doRenderLayer(EntityLivingBase p_doRenderLayer_1_, float p_doRenderLayer_2_, float p_doRenderLayer_3_, float p_doRenderLayer_4_, float p_doRenderLayer_5_, float p_doRenderLayer_6_, float p_doRenderLayer_7_, float p_doRenderLayer_8_) {
        ItemStack itemstack1;
        boolean flag = p_doRenderLayer_1_.getPrimaryHand() == EnumHandSide.RIGHT;
        ItemStack itemstack = flag ? p_doRenderLayer_1_.getHeldItemOffhand() : p_doRenderLayer_1_.getHeldItemMainhand();
        ItemStack itemStack = itemstack1 = flag ? p_doRenderLayer_1_.getHeldItemMainhand() : p_doRenderLayer_1_.getHeldItemOffhand();
        if (!itemstack.isEmpty() || !itemstack1.isEmpty()) {
            GlStateManager.pushMatrix();
            if (this.livingEntityRenderer.getMainModel().isChild) {
                float f = 0.5f;
                GlStateManager.translate(0.0f, 0.75f, 0.0f);
                GlStateManager.scale(0.5f, 0.5f, 0.5f);
            }
            this.renderHeldItem(p_doRenderLayer_1_, itemstack1, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
            this.renderHeldItem(p_doRenderLayer_1_, itemstack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT);
            GlStateManager.popMatrix();
        }
    }

    private void renderHeldItem(EntityLivingBase p_renderHeldItem_1_, ItemStack p_renderHeldItem_2_, ItemCameraTransforms.TransformType p_renderHeldItem_3_, EnumHandSide p_renderHeldItem_4_) {
        if (!p_renderHeldItem_2_.isEmpty()) {
            GlStateManager.pushMatrix();
            if (p_renderHeldItem_1_.isSneaking()) {
                GlStateManager.translate(0.0f, 0.2f, 0.0f);
            }
            this.translateToHand(p_renderHeldItem_4_);
            GlStateManager.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
            GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
            boolean flag = p_renderHeldItem_4_ == EnumHandSide.LEFT;
            GlStateManager.translate((float)(flag ? -1 : 1) / 16.0f, 0.125f, -0.625f);
            Minecraft.getMinecraft().getItemRenderer().renderItemSide(p_renderHeldItem_1_, p_renderHeldItem_2_, p_renderHeldItem_3_, flag);
            GlStateManager.popMatrix();
        }
    }

    protected void translateToHand(EnumHandSide p_translateToHand_1_) {
        ((ModelBiped)this.livingEntityRenderer.getMainModel()).postRenderArm(0.0625f, p_translateToHand_1_);
    }

    @Override
    public boolean shouldCombineTextures() {
        return false;
    }
}

