/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderIronGolem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerIronGolemFlower
implements LayerRenderer<EntityIronGolem> {
    private final RenderIronGolem ironGolemRenderer;

    public LayerIronGolemFlower(RenderIronGolem p_i46107_1_) {
        this.ironGolemRenderer = p_i46107_1_;
    }

    @Override
    public void doRenderLayer(EntityIronGolem p_doRenderLayer_1_, float p_doRenderLayer_2_, float p_doRenderLayer_3_, float p_doRenderLayer_4_, float p_doRenderLayer_5_, float p_doRenderLayer_6_, float p_doRenderLayer_7_, float p_doRenderLayer_8_) {
        if (p_doRenderLayer_1_.getHoldRoseTick() == 0) {
            return;
        }
        BlockRendererDispatcher lvt_9_1_ = Minecraft.getMinecraft().getBlockRendererDispatcher();
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        GlStateManager.rotate(5.0f + 180.0f * ((ModelIronGolem)this.ironGolemRenderer.getMainModel()).ironGolemRightArm.rotateAngleX / (float)Math.PI, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.translate(-0.9375f, -0.625f, -0.9375f);
        float lvt_10_1_ = 0.5f;
        GlStateManager.scale(0.5f, -0.5f, 0.5f);
        int lvt_11_1_ = p_doRenderLayer_1_.getBrightnessForRender(p_doRenderLayer_4_);
        int lvt_12_1_ = lvt_11_1_ % 65536;
        int lvt_13_1_ = lvt_11_1_ / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, lvt_12_1_, lvt_13_1_);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.ironGolemRenderer.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        lvt_9_1_.renderBlockBrightness(Blocks.RED_FLOWER.getDefaultState(), 1.0f);
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
    }

    @Override
    public boolean shouldCombineTextures() {
        return false;
    }
}

