/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import net.minecraft.client.model.ModelSheep1;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderSheep;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerSheepWool
implements LayerRenderer<EntitySheep> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/sheep/sheep_fur.png");
    private final RenderSheep sheepRenderer;
    private final ModelSheep1 sheepModel = new ModelSheep1();

    public LayerSheepWool(RenderSheep p_i46112_1_) {
        this.sheepRenderer = p_i46112_1_;
    }

    @Override
    public void doRenderLayer(EntitySheep p_doRenderLayer_1_, float p_doRenderLayer_2_, float p_doRenderLayer_3_, float p_doRenderLayer_4_, float p_doRenderLayer_5_, float p_doRenderLayer_6_, float p_doRenderLayer_7_, float p_doRenderLayer_8_) {
        if (p_doRenderLayer_1_.getSheared() || p_doRenderLayer_1_.isInvisible()) {
            return;
        }
        this.sheepRenderer.bindTexture(TEXTURE);
        if (p_doRenderLayer_1_.hasCustomName() && "jeb_".equals(p_doRenderLayer_1_.getCustomNameTag())) {
            int lvt_9_1_ = 25;
            int lvt_10_1_ = p_doRenderLayer_1_.ticksExisted / 25 + p_doRenderLayer_1_.getEntityId();
            int lvt_11_1_ = EnumDyeColor.values().length;
            int lvt_12_1_ = lvt_10_1_ % lvt_11_1_;
            int lvt_13_1_ = (lvt_10_1_ + 1) % lvt_11_1_;
            float lvt_14_1_ = ((float)(p_doRenderLayer_1_.ticksExisted % 25) + p_doRenderLayer_4_) / 25.0f;
            float[] lvt_15_1_ = EntitySheep.getDyeRgb(EnumDyeColor.byMetadata(lvt_12_1_));
            float[] lvt_16_1_ = EntitySheep.getDyeRgb(EnumDyeColor.byMetadata(lvt_13_1_));
            GlStateManager.color(lvt_15_1_[0] * (1.0f - lvt_14_1_) + lvt_16_1_[0] * lvt_14_1_, lvt_15_1_[1] * (1.0f - lvt_14_1_) + lvt_16_1_[1] * lvt_14_1_, lvt_15_1_[2] * (1.0f - lvt_14_1_) + lvt_16_1_[2] * lvt_14_1_);
        } else {
            float[] lvt_9_2_ = EntitySheep.getDyeRgb(p_doRenderLayer_1_.getFleeceColor());
            GlStateManager.color(lvt_9_2_[0], lvt_9_2_[1], lvt_9_2_[2]);
        }
        this.sheepModel.setModelAttributes(this.sheepRenderer.getMainModel());
        this.sheepModel.setLivingAnimations(p_doRenderLayer_1_, p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_4_);
        this.sheepModel.render(p_doRenderLayer_1_, p_doRenderLayer_2_, p_doRenderLayer_3_, p_doRenderLayer_5_, p_doRenderLayer_6_, p_doRenderLayer_7_, p_doRenderLayer_8_);
    }

    @Override
    public boolean shouldCombineTextures() {
        return true;
    }
}

