/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractTexture
implements ITextureObject {
    protected int glTextureId = -1;
    protected boolean blur;
    protected boolean mipmap;
    protected boolean blurLast;
    protected boolean mipmapLast;

    public void setBlurMipmapDirect(boolean p_setBlurMipmapDirect_1_, boolean p_setBlurMipmapDirect_2_) {
        int lvt_4_2_;
        int lvt_3_2_;
        this.blur = p_setBlurMipmapDirect_1_;
        this.mipmap = p_setBlurMipmapDirect_2_;
        if (p_setBlurMipmapDirect_1_) {
            int lvt_3_1_ = p_setBlurMipmapDirect_2_ ? 9987 : 9729;
            int lvt_4_1_ = 9729;
        } else {
            lvt_3_2_ = p_setBlurMipmapDirect_2_ ? 9986 : 9728;
            lvt_4_2_ = 9728;
        }
        GlStateManager.glTexParameteri(3553, 10241, lvt_3_2_);
        GlStateManager.glTexParameteri(3553, 10240, lvt_4_2_);
    }

    @Override
    public void setBlurMipmap(boolean p_setBlurMipmap_1_, boolean p_setBlurMipmap_2_) {
        this.blurLast = this.blur;
        this.mipmapLast = this.mipmap;
        this.setBlurMipmapDirect(p_setBlurMipmap_1_, p_setBlurMipmap_2_);
    }

    @Override
    public void restoreLastBlurMipmap() {
        this.setBlurMipmapDirect(this.blurLast, this.mipmapLast);
    }

    @Override
    public int getGlTextureId() {
        if (this.glTextureId == -1) {
            this.glTextureId = TextureUtil.glGenTextures();
        }
        return this.glTextureId;
    }

    public void deleteGlTexture() {
        if (this.glTextureId != -1) {
            TextureUtil.deleteTexture(this.glTextureId);
            this.glTextureId = -1;
        }
    }
}

