/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class LayeredColorMaskTexture
extends AbstractTexture {
    private static final Logger LOG = LogManager.getLogger();
    private final ResourceLocation textureLocation;
    private final List<String> listTextures;
    private final List<EnumDyeColor> listDyeColors;

    public LayeredColorMaskTexture(ResourceLocation p_i46101_1_, List<String> p_i46101_2_, List<EnumDyeColor> p_i46101_3_) {
        this.textureLocation = p_i46101_1_;
        this.listTextures = p_i46101_2_;
        this.listDyeColors = p_i46101_3_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void loadTexture(IResourceManager p_loadTexture_1_) throws IOException {
        void lvt_2_2_;
        this.deleteGlTexture();
        IResource lvt_3_1_ = null;
        try {
            lvt_3_1_ = p_loadTexture_1_.getResource(this.textureLocation);
            BufferedImage lvt_4_1_ = TextureUtil.readBufferedImage(lvt_3_1_.getInputStream());
            int lvt_5_1_ = lvt_4_1_.getType();
            if (lvt_5_1_ == 0) {
                lvt_5_1_ = 6;
            }
            BufferedImage lvt_2_1_ = new BufferedImage(lvt_4_1_.getWidth(), lvt_4_1_.getHeight(), lvt_5_1_);
            Graphics lvt_6_1_ = lvt_2_1_.getGraphics();
            lvt_6_1_.drawImage(lvt_4_1_, 0, 0, null);
            for (int lvt_7_1_ = 0; lvt_7_1_ < 17 && lvt_7_1_ < this.listTextures.size() && lvt_7_1_ < this.listDyeColors.size(); ++lvt_7_1_) {
                BufferedImage lvt_11_1_;
                MapColor lvt_10_1_;
                IResource lvt_8_1_;
                block13: {
                    String lvt_9_1_;
                    block12: {
                        lvt_8_1_ = null;
                        lvt_9_1_ = this.listTextures.get(lvt_7_1_);
                        lvt_10_1_ = this.listDyeColors.get(lvt_7_1_).getMapColor();
                        if (lvt_9_1_ != null) break block12;
                        IOUtils.closeQuietly(lvt_8_1_);
                        continue;
                    }
                    lvt_8_1_ = p_loadTexture_1_.getResource(new ResourceLocation(lvt_9_1_));
                    lvt_11_1_ = TextureUtil.readBufferedImage(lvt_8_1_.getInputStream());
                    if (lvt_11_1_.getWidth() == lvt_2_1_.getWidth() && lvt_11_1_.getHeight() == lvt_2_1_.getHeight() && lvt_11_1_.getType() == 6) break block13;
                    IOUtils.closeQuietly((Closeable)lvt_8_1_);
                    continue;
                }
                try {
                    for (int lvt_12_1_ = 0; lvt_12_1_ < lvt_11_1_.getHeight(); ++lvt_12_1_) {
                        for (int lvt_13_1_ = 0; lvt_13_1_ < lvt_11_1_.getWidth(); ++lvt_13_1_) {
                            int lvt_14_1_ = lvt_11_1_.getRGB(lvt_13_1_, lvt_12_1_);
                            if ((lvt_14_1_ & 0xFF000000) == 0) continue;
                            int lvt_15_1_ = (lvt_14_1_ & 0xFF0000) << 8 & 0xFF000000;
                            int lvt_16_1_ = lvt_4_1_.getRGB(lvt_13_1_, lvt_12_1_);
                            int lvt_17_1_ = MathHelper.multiplyColor(lvt_16_1_, lvt_10_1_.colorValue) & 0xFFFFFF;
                            lvt_11_1_.setRGB(lvt_13_1_, lvt_12_1_, lvt_15_1_ | lvt_17_1_);
                        }
                    }
                    lvt_2_1_.getGraphics().drawImage(lvt_11_1_, 0, 0, null);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(lvt_8_1_);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)lvt_8_1_);
            }
        }
        catch (IOException lvt_4_2_) {
            try {
                LOG.error("Couldn't load layered image", (Throwable)lvt_4_2_);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lvt_3_1_);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)lvt_3_1_);
            return;
        }
        IOUtils.closeQuietly((Closeable)lvt_3_1_);
        TextureUtil.uploadTextureImage(this.getGlTextureId(), (BufferedImage)lvt_2_2_);
    }
}

