/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class LayeredTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    public final List<String> layeredTextureNames;

    public LayeredTexture(String ... p_i1274_1_) {
        this.layeredTextureNames = Lists.newArrayList((Object[])p_i1274_1_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTexture(IResourceManager p_loadTexture_1_) throws IOException {
        this.deleteGlTexture();
        BufferedImage lvt_2_1_ = null;
        for (String lvt_4_1_ : this.layeredTextureNames) {
            IResource lvt_5_1_ = null;
            try {
                if (lvt_4_1_ == null) continue;
                lvt_5_1_ = p_loadTexture_1_.getResource(new ResourceLocation(lvt_4_1_));
                BufferedImage lvt_6_1_ = TextureUtil.readBufferedImage(lvt_5_1_.getInputStream());
                if (lvt_2_1_ == null) {
                    lvt_2_1_ = new BufferedImage(lvt_6_1_.getWidth(), lvt_6_1_.getHeight(), 2);
                }
                lvt_2_1_.getGraphics().drawImage(lvt_6_1_, 0, 0, null);
                IOUtils.closeQuietly((Closeable)lvt_5_1_);
            }
            catch (IOException lvt_6_2_) {
                LOGGER.error("Couldn't load layered image", (Throwable)lvt_6_2_);
                return;
            }
            finally {
                IOUtils.closeQuietly(lvt_5_1_);
            }
        }
        TextureUtil.uploadTextureImage(this.getGlTextureId(), lvt_2_1_);
    }
}

