/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.resources.IResource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class PngSizeInfo {
    public final int pngWidth;
    public final int pngHeight;

    public PngSizeInfo(InputStream p_i46543_1_) throws IOException {
        DataInputStream lvt_2_1_ = new DataInputStream(p_i46543_1_);
        if (lvt_2_1_.readLong() != -8552249625308161526L) {
            throw new IOException("Bad PNG Signature");
        }
        if (lvt_2_1_.readInt() != 13) {
            throw new IOException("Bad length for IHDR chunk!");
        }
        if (lvt_2_1_.readInt() != 1229472850) {
            throw new IOException("Bad type for IHDR chunk!");
        }
        this.pngWidth = lvt_2_1_.readInt();
        this.pngHeight = lvt_2_1_.readInt();
        IOUtils.closeQuietly((InputStream)lvt_2_1_);
    }

    public static PngSizeInfo makeFromResource(IResource p_makeFromResource_0_) throws IOException {
        try {
            PngSizeInfo pngSizeInfo = new PngSizeInfo(p_makeFromResource_0_.getInputStream());
            return pngSizeInfo;
        }
        finally {
            IOUtils.closeQuietly((Closeable)p_makeFromResource_0_);
        }
    }
}

