/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class SimpleTexture
extends AbstractTexture {
    private static final Logger LOG = LogManager.getLogger();
    protected final ResourceLocation textureLocation;

    public SimpleTexture(ResourceLocation p_i1275_1_) {
        this.textureLocation = p_i1275_1_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTexture(IResourceManager p_loadTexture_1_) throws IOException {
        this.deleteGlTexture();
        IResource lvt_2_1_ = null;
        try {
            lvt_2_1_ = p_loadTexture_1_.getResource(this.textureLocation);
            BufferedImage lvt_3_1_ = TextureUtil.readBufferedImage(lvt_2_1_.getInputStream());
            boolean lvt_4_1_ = false;
            boolean lvt_5_1_ = false;
            if (lvt_2_1_.hasMetadata()) {
                try {
                    TextureMetadataSection lvt_6_1_ = (TextureMetadataSection)lvt_2_1_.getMetadata("texture");
                    if (lvt_6_1_ != null) {
                        lvt_4_1_ = lvt_6_1_.getTextureBlur();
                        lvt_5_1_ = lvt_6_1_.getTextureClamp();
                    }
                }
                catch (RuntimeException lvt_6_2_) {
                    LOG.warn("Failed reading metadata of: {}", new Object[]{this.textureLocation, lvt_6_2_});
                }
            }
            TextureUtil.uploadTextureImageAllocate(this.getGlTextureId(), lvt_3_1_, lvt_4_1_, lvt_5_1_);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lvt_2_1_);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)lvt_2_1_);
    }
}

