/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureAtlasSprite {
    private final String iconName;
    protected List<int[][]> framesTextureData = Lists.newArrayList();
    protected int[][] interpolatedFrameData;
    private AnimationMetadataSection animationMetadata;
    protected boolean rotated;
    protected int originX;
    protected int originY;
    protected int width;
    protected int height;
    private float minU;
    private float maxU;
    private float minV;
    private float maxV;
    protected int frameCounter;
    protected int tickCounter;

    protected TextureAtlasSprite(String p_i1282_1_) {
        this.iconName = p_i1282_1_;
    }

    protected static TextureAtlasSprite makeAtlasSprite(ResourceLocation p_makeAtlasSprite_0_) {
        return new TextureAtlasSprite(p_makeAtlasSprite_0_.toString());
    }

    public void initSprite(int p_initSprite_1_, int p_initSprite_2_, int p_initSprite_3_, int p_initSprite_4_, boolean p_initSprite_5_) {
        this.originX = p_initSprite_3_;
        this.originY = p_initSprite_4_;
        this.rotated = p_initSprite_5_;
        this.minU = (float)p_initSprite_3_ / (float)p_initSprite_1_;
        this.maxU = (float)(p_initSprite_3_ + this.width) / (float)p_initSprite_1_;
        this.minV = (float)p_initSprite_4_ / (float)p_initSprite_2_;
        this.maxV = (float)(p_initSprite_4_ + this.height) / (float)p_initSprite_2_;
    }

    public void copyFrom(TextureAtlasSprite p_copyFrom_1_) {
        this.originX = p_copyFrom_1_.originX;
        this.originY = p_copyFrom_1_.originY;
        this.width = p_copyFrom_1_.width;
        this.height = p_copyFrom_1_.height;
        this.rotated = p_copyFrom_1_.rotated;
        this.minU = p_copyFrom_1_.minU;
        this.maxU = p_copyFrom_1_.maxU;
        this.minV = p_copyFrom_1_.minV;
        this.maxV = p_copyFrom_1_.maxV;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public float getMinU() {
        return this.minU;
    }

    public float getMaxU() {
        return this.maxU;
    }

    public float getInterpolatedU(double p_getInterpolatedU_1_) {
        float f = this.maxU - this.minU;
        return this.minU + f * (float)p_getInterpolatedU_1_ / 16.0f;
    }

    public float getUnInterpolatedU(float p_getUnInterpolatedU_1_) {
        float f = this.maxU - this.minU;
        return (p_getUnInterpolatedU_1_ - this.minU) / f * 16.0f;
    }

    public float getMinV() {
        return this.minV;
    }

    public float getMaxV() {
        return this.maxV;
    }

    public float getInterpolatedV(double p_getInterpolatedV_1_) {
        float f = this.maxV - this.minV;
        return this.minV + f * (float)p_getInterpolatedV_1_ / 16.0f;
    }

    public float getUnInterpolatedV(float p_getUnInterpolatedV_1_) {
        float f = this.maxV - this.minV;
        return (p_getUnInterpolatedV_1_ - this.minV) / f * 16.0f;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void updateAnimation() {
        ++this.tickCounter;
        if (this.tickCounter >= this.animationMetadata.getFrameTimeSingle(this.frameCounter)) {
            int i = this.animationMetadata.getFrameIndex(this.frameCounter);
            int j = this.animationMetadata.getFrameCount() == 0 ? this.framesTextureData.size() : this.animationMetadata.getFrameCount();
            this.frameCounter = (this.frameCounter + 1) % j;
            this.tickCounter = 0;
            int k = this.animationMetadata.getFrameIndex(this.frameCounter);
            if (i != k && k >= 0 && k < this.framesTextureData.size()) {
                TextureUtil.uploadTextureMipmap(this.framesTextureData.get(k), this.width, this.height, this.originX, this.originY, false, false);
            }
        } else if (this.animationMetadata.isInterpolate()) {
            this.updateAnimationInterpolated();
        }
    }

    private void updateAnimationInterpolated() {
        int j;
        int k;
        double d0 = 1.0 - (double)this.tickCounter / (double)this.animationMetadata.getFrameTimeSingle(this.frameCounter);
        int i = this.animationMetadata.getFrameIndex(this.frameCounter);
        if (i != (k = this.animationMetadata.getFrameIndex((this.frameCounter + 1) % (j = this.animationMetadata.getFrameCount() == 0 ? this.framesTextureData.size() : this.animationMetadata.getFrameCount()))) && k >= 0 && k < this.framesTextureData.size()) {
            int[][] aint = this.framesTextureData.get(i);
            int[][] aint1 = this.framesTextureData.get(k);
            if (this.interpolatedFrameData == null || this.interpolatedFrameData.length != aint.length) {
                this.interpolatedFrameData = new int[aint.length][];
            }
            for (int l = 0; l < aint.length; ++l) {
                if (this.interpolatedFrameData[l] == null) {
                    this.interpolatedFrameData[l] = new int[aint[l].length];
                }
                if (l >= aint1.length || aint1[l].length != aint[l].length) continue;
                for (int i1 = 0; i1 < aint[l].length; ++i1) {
                    int j1 = aint[l][i1];
                    int k1 = aint1[l][i1];
                    int l1 = this.interpolateColor(d0, j1 >> 16 & 0xFF, k1 >> 16 & 0xFF);
                    int i2 = this.interpolateColor(d0, j1 >> 8 & 0xFF, k1 >> 8 & 0xFF);
                    int j2 = this.interpolateColor(d0, j1 & 0xFF, k1 & 0xFF);
                    this.interpolatedFrameData[l][i1] = j1 & 0xFF000000 | l1 << 16 | i2 << 8 | j2;
                }
            }
            TextureUtil.uploadTextureMipmap(this.interpolatedFrameData, this.width, this.height, this.originX, this.originY, false, false);
        }
    }

    private int interpolateColor(double p_interpolateColor_1_, int p_interpolateColor_3_, int p_interpolateColor_4_) {
        return (int)(p_interpolateColor_1_ * (double)p_interpolateColor_3_ + (1.0 - p_interpolateColor_1_) * (double)p_interpolateColor_4_);
    }

    public int[][] getFrameTextureData(int p_getFrameTextureData_1_) {
        return this.framesTextureData.get(p_getFrameTextureData_1_);
    }

    public int getFrameCount() {
        return this.framesTextureData.size();
    }

    public void setIconWidth(int p_setIconWidth_1_) {
        this.width = p_setIconWidth_1_;
    }

    public void setIconHeight(int p_setIconHeight_1_) {
        this.height = p_setIconHeight_1_;
    }

    public void loadSprite(PngSizeInfo p_loadSprite_1_, boolean p_loadSprite_2_) throws IOException {
        this.resetSprite();
        this.width = p_loadSprite_1_.pngWidth;
        this.height = p_loadSprite_1_.pngHeight;
        if (p_loadSprite_2_) {
            this.height = this.width;
        } else if (p_loadSprite_1_.pngHeight != p_loadSprite_1_.pngWidth) {
            throw new RuntimeException("broken aspect ratio and not an animation");
        }
    }

    public void loadSpriteFrames(IResource p_loadSpriteFrames_1_, int p_loadSpriteFrames_2_) throws IOException {
        BufferedImage bufferedimage = TextureUtil.readBufferedImage(p_loadSpriteFrames_1_.getInputStream());
        AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)p_loadSpriteFrames_1_.getMetadata("animation");
        int[][] aint = new int[p_loadSpriteFrames_2_][];
        aint[0] = new int[bufferedimage.getWidth() * bufferedimage.getHeight()];
        bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), aint[0], 0, bufferedimage.getWidth());
        if (animationmetadatasection == null) {
            this.framesTextureData.add(aint);
        } else {
            int i = bufferedimage.getHeight() / this.width;
            if (animationmetadatasection.getFrameCount() > 0) {
                for (int j : animationmetadatasection.getFrameIndexSet()) {
                    if (j >= i) {
                        throw new RuntimeException("invalid frameindex " + j);
                    }
                    this.allocateFrameTextureData(j);
                    this.framesTextureData.set(j, TextureAtlasSprite.getFrameTextureData(aint, this.width, this.width, j));
                }
                this.animationMetadata = animationmetadatasection;
            } else {
                ArrayList list = Lists.newArrayList();
                for (int k = 0; k < i; ++k) {
                    this.framesTextureData.add(TextureAtlasSprite.getFrameTextureData(aint, this.width, this.width, k));
                    list.add(new AnimationFrame(k, -1));
                }
                this.animationMetadata = new AnimationMetadataSection(list, this.width, this.height, animationmetadatasection.getFrameTime(), animationmetadatasection.isInterpolate());
            }
        }
    }

    public void generateMipmaps(int p_generateMipmaps_1_) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.framesTextureData.size(); ++i) {
            final int[][] aint = this.framesTextureData.get(i);
            if (aint == null) continue;
            try {
                list.add(TextureUtil.generateMipmapData(p_generateMipmaps_1_, this.width, aint));
                continue;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Generating mipmaps for frame");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Frame being iterated");
                crashreportcategory.addCrashSection("Frame index", i);
                crashreportcategory.setDetail("Frame sizes", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        StringBuilder stringbuilder = new StringBuilder();
                        for (int[] aint1 : aint) {
                            if (stringbuilder.length() > 0) {
                                stringbuilder.append(", ");
                            }
                            stringbuilder.append(aint1 == null ? "null" : Integer.valueOf(aint1.length));
                        }
                        return stringbuilder.toString();
                    }
                });
                throw new ReportedException(crashreport);
            }
        }
        this.setFramesTextureData(list);
    }

    private void allocateFrameTextureData(int p_allocateFrameTextureData_1_) {
        if (this.framesTextureData.size() <= p_allocateFrameTextureData_1_) {
            for (int i = this.framesTextureData.size(); i <= p_allocateFrameTextureData_1_; ++i) {
                this.framesTextureData.add(null);
            }
        }
    }

    private static int[][] getFrameTextureData(int[][] p_getFrameTextureData_0_, int p_getFrameTextureData_1_, int p_getFrameTextureData_2_, int p_getFrameTextureData_3_) {
        int[][] aint = new int[p_getFrameTextureData_0_.length][];
        for (int i = 0; i < p_getFrameTextureData_0_.length; ++i) {
            int[] aint1 = p_getFrameTextureData_0_[i];
            if (aint1 == null) continue;
            aint[i] = new int[(p_getFrameTextureData_1_ >> i) * (p_getFrameTextureData_2_ >> i)];
            System.arraycopy(aint1, p_getFrameTextureData_3_ * aint[i].length, aint[i], 0, aint[i].length);
        }
        return aint;
    }

    public void clearFramesTextureData() {
        this.framesTextureData.clear();
    }

    public boolean hasAnimationMetadata() {
        return this.animationMetadata != null;
    }

    public void setFramesTextureData(List<int[][]> p_setFramesTextureData_1_) {
        this.framesTextureData = p_setFramesTextureData_1_;
    }

    private void resetSprite() {
        this.animationMetadata = null;
        this.setFramesTextureData(Lists.newArrayList());
        this.frameCounter = 0;
        this.tickCounter = 0;
    }

    public String toString() {
        return "TextureAtlasSprite{name='" + this.iconName + '\'' + ", frameCount=" + this.framesTextureData.size() + ", rotated=" + this.rotated + ", x=" + this.originX + ", y=" + this.originY + ", height=" + this.height + ", width=" + this.width + ", u0=" + this.minU + ", u1=" + this.maxU + ", v0=" + this.minV + ", v1=" + this.maxV + '}';
    }

    public boolean hasCustomLoader(IResourceManager p_hasCustomLoader_1_, ResourceLocation p_hasCustomLoader_2_) {
        return false;
    }

    public boolean load(IResourceManager p_load_1_, ResourceLocation p_load_2_) {
        return true;
    }
}

