/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class TextureManager
implements ITickable,
IResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, ITextureObject> mapTextureObjects = Maps.newHashMap();
    private final List<ITickable> listTickables = Lists.newArrayList();
    private final Map<String, Integer> mapTextureCounters = Maps.newHashMap();
    private final IResourceManager theResourceManager;

    public TextureManager(IResourceManager p_i1284_1_) {
        this.theResourceManager = p_i1284_1_;
    }

    public void bindTexture(ResourceLocation p_bindTexture_1_) {
        ITextureObject itextureobject = this.mapTextureObjects.get(p_bindTexture_1_);
        if (itextureobject == null) {
            itextureobject = new SimpleTexture(p_bindTexture_1_);
            this.loadTexture(p_bindTexture_1_, itextureobject);
        }
        TextureUtil.bindTexture(itextureobject.getGlTextureId());
    }

    public boolean loadTickableTexture(ResourceLocation p_loadTickableTexture_1_, ITickableTextureObject p_loadTickableTexture_2_) {
        if (this.loadTexture(p_loadTickableTexture_1_, p_loadTickableTexture_2_)) {
            this.listTickables.add(p_loadTickableTexture_2_);
            return true;
        }
        return false;
    }

    public boolean loadTexture(ResourceLocation p_loadTexture_1_, ITextureObject p_loadTexture_2_) {
        boolean flag = true;
        try {
            p_loadTexture_2_.loadTexture(this.theResourceManager);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to load texture: {}", new Object[]{p_loadTexture_1_, ioexception});
            p_loadTexture_2_ = TextureUtil.MISSING_TEXTURE;
            this.mapTextureObjects.put(p_loadTexture_1_, p_loadTexture_2_);
            flag = false;
        }
        catch (Throwable throwable) {
            final ITextureObject p_110579_2_f = p_loadTexture_2_;
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Registering texture");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Resource location being registered");
            crashreportcategory.addCrashSection("Resource location", p_loadTexture_1_);
            crashreportcategory.setDetail("Texture object class", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return p_110579_2_f.getClass().getName();
                }
            });
            throw new ReportedException(crashreport);
        }
        this.mapTextureObjects.put(p_loadTexture_1_, p_loadTexture_2_);
        return flag;
    }

    public ITextureObject getTexture(ResourceLocation p_getTexture_1_) {
        return this.mapTextureObjects.get(p_getTexture_1_);
    }

    public ResourceLocation getDynamicTextureLocation(String p_getDynamicTextureLocation_1_, DynamicTexture p_getDynamicTextureLocation_2_) {
        Integer integer = this.mapTextureCounters.get(p_getDynamicTextureLocation_1_);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.mapTextureCounters.put(p_getDynamicTextureLocation_1_, integer);
        ResourceLocation resourcelocation = new ResourceLocation(String.format("dynamic/%s_%d", p_getDynamicTextureLocation_1_, integer));
        this.loadTexture(resourcelocation, p_getDynamicTextureLocation_2_);
        return resourcelocation;
    }

    @Override
    public void tick() {
        for (ITickable itickable : this.listTickables) {
            itickable.tick();
        }
    }

    public void deleteTexture(ResourceLocation p_deleteTexture_1_) {
        ITextureObject itextureobject = this.getTexture(p_deleteTexture_1_);
        if (itextureobject != null) {
            this.mapTextureObjects.remove(p_deleteTexture_1_);
            TextureUtil.deleteTexture(itextureobject.getGlTextureId());
        }
    }

    @Override
    public void onResourceManagerReload(IResourceManager p_onResourceManagerReload_1_) {
        ProgressManager.ProgressBar bar = ProgressManager.push("Reloading Texture Manager", this.mapTextureObjects.keySet().size(), true);
        for (Map.Entry<ResourceLocation, ITextureObject> entry : this.mapTextureObjects.entrySet()) {
            bar.step(entry.getKey().toString());
            this.loadTexture(entry.getKey(), entry.getValue());
        }
        ProgressManager.pop(bar);
    }
}

