/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureMapPopulator;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class TextureMap
extends AbstractTexture
implements ITickableTextureObject {
    private static final boolean ENABLE_SKIP = Boolean.parseBoolean(System.getProperty("fml.skipFirstTextureLoad", "true"));
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation LOCATION_MISSING_TEXTURE = new ResourceLocation("missingno");
    public static final ResourceLocation LOCATION_BLOCKS_TEXTURE = new ResourceLocation("textures/atlas/blocks.png");
    private final List<TextureAtlasSprite> listAnimatedSprites = Lists.newArrayList();
    private final Map<String, TextureAtlasSprite> mapRegisteredSprites = Maps.newHashMap();
    private final Map<String, TextureAtlasSprite> mapUploadedSprites = Maps.newHashMap();
    private final String basePath;
    private final ITextureMapPopulator iconCreator;
    private int mipmapLevels;
    private final TextureAtlasSprite missingImage = new TextureAtlasSprite("missingno");
    private boolean skipFirst = false;

    public TextureMap(String p_i46099_1_) {
        this(p_i46099_1_, null);
    }

    public TextureMap(String p_i46100_1_, ITextureMapPopulator p_i46100_2_) {
        this(p_i46100_1_, p_i46100_2_, false);
    }

    public TextureMap(String p_i20_1_, boolean p_i20_2_) {
        this(p_i20_1_, null, p_i20_2_);
    }

    public TextureMap(String p_i21_1_, ITextureMapPopulator p_i21_2_, boolean p_i21_3_) {
        this.basePath = p_i21_1_;
        this.iconCreator = p_i21_2_;
        this.skipFirst = p_i21_3_ && ENABLE_SKIP;
    }

    private void initMissingImage() {
        int[] aint = TextureUtil.MISSING_TEXTURE_DATA;
        this.missingImage.setIconWidth(16);
        this.missingImage.setIconHeight(16);
        int[][] aint1 = new int[this.mipmapLevels + 1][];
        aint1[0] = aint;
        this.missingImage.setFramesTextureData(Lists.newArrayList((Object[])new int[][][]{aint1}));
    }

    @Override
    public void loadTexture(IResourceManager p_loadTexture_1_) throws IOException {
        if (this.iconCreator != null) {
            this.loadSprites(p_loadTexture_1_, this.iconCreator);
        }
    }

    public void loadSprites(IResourceManager p_loadSprites_1_, ITextureMapPopulator p_loadSprites_2_) {
        this.mapRegisteredSprites.clear();
        ForgeHooksClient.onTextureStitchedPre(this);
        p_loadSprites_2_.registerSprites(this);
        this.initMissingImage();
        this.deleteGlTexture();
        this.loadTextureAtlas(p_loadSprites_1_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadTextureAtlas(IResourceManager p_loadTextureAtlas_1_) {
        int i = Minecraft.getGLMaximumTextureSize();
        Stitcher stitcher = new Stitcher(i, i, 0, this.mipmapLevels);
        this.mapUploadedSprites.clear();
        this.listAnimatedSprites.clear();
        int j = Integer.MAX_VALUE;
        int k = 1 << this.mipmapLevels;
        FMLLog.info("Max texture size: %d", i);
        ProgressManager.ProgressBar bar = ProgressManager.push("Texture stitching", this.skipFirst ? 0 : this.mapRegisteredSprites.size());
        if (!this.skipFirst) {
            for (Map.Entry<String, TextureAtlasSprite> entry : this.mapRegisteredSprites.entrySet()) {
                TextureAtlasSprite textureatlassprite = entry.getValue();
                ResourceLocation resourcelocation = this.getResourceLocation(textureatlassprite);
                bar.step(resourcelocation.getResourcePath());
                IResource iresource = null;
                if (textureatlassprite.hasCustomLoader(p_loadTextureAtlas_1_, resourcelocation)) {
                    if (textureatlassprite.load(p_loadTextureAtlas_1_, resourcelocation)) {
                        continue;
                    }
                } else {
                    try {
                        PngSizeInfo pngsizeinfo = PngSizeInfo.makeFromResource(p_loadTextureAtlas_1_.getResource(resourcelocation));
                        iresource = p_loadTextureAtlas_1_.getResource(resourcelocation);
                        boolean flag = iresource.getMetadata("animation") != null;
                        textureatlassprite.loadSprite(pngsizeinfo, flag);
                        IOUtils.closeQuietly((Closeable)iresource);
                    }
                    catch (RuntimeException runtimeexception) {
                        FMLClientHandler.instance().trackBrokenTexture(resourcelocation, runtimeexception.getMessage());
                        IOUtils.closeQuietly((Closeable)iresource);
                        continue;
                    }
                    catch (IOException ioexception) {
                        FMLClientHandler.instance().trackMissingTexture(resourcelocation);
                        continue;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        IOUtils.closeQuietly(iresource);
                        continue;
                    }
                }
                j = Math.min(j, Math.min(textureatlassprite.getIconWidth(), textureatlassprite.getIconHeight()));
                int lvt_11_2_ = Math.min(Integer.lowestOneBit(textureatlassprite.getIconWidth()), Integer.lowestOneBit(textureatlassprite.getIconHeight()));
                if (lvt_11_2_ < k) {
                    LOGGER.warn("Texture {} with size {}x{} will have visual artifacts at mip level {}, it can only support level {}. Please report to the mod author that the texture should be some multiple of 16x16.", new Object[]{resourcelocation, textureatlassprite.getIconWidth(), textureatlassprite.getIconHeight(), MathHelper.log2(k), MathHelper.log2(lvt_11_2_)});
                }
                stitcher.addSprite(textureatlassprite);
            }
        }
        ProgressManager.pop(bar);
        int l = Math.min(j, k);
        int i1 = MathHelper.log2(l);
        this.missingImage.generateMipmaps(this.mipmapLevels);
        stitcher.addSprite(this.missingImage);
        this.skipFirst = false;
        bar = ProgressManager.push("Texture creation", 2);
        bar.step("Stitching");
        stitcher.doStitch();
        LOGGER.info("Created: {}x{} {}-atlas", new Object[]{stitcher.getCurrentWidth(), stitcher.getCurrentHeight(), this.basePath});
        bar.step("Allocating GL texture");
        TextureUtil.allocateTextureImpl(this.getGlTextureId(), this.mipmapLevels, stitcher.getCurrentWidth(), stitcher.getCurrentHeight());
        HashMap map = Maps.newHashMap(this.mapRegisteredSprites);
        ProgressManager.pop(bar);
        bar = ProgressManager.push("Texture mipmap and upload", stitcher.getStichSlots().size());
        for (TextureAtlasSprite textureatlassprite1 : stitcher.getStichSlots()) {
            bar.step(textureatlassprite1.getIconName());
            if (textureatlassprite1 != this.missingImage && !this.generateMipmaps(p_loadTextureAtlas_1_, textureatlassprite1)) continue;
            String s = textureatlassprite1.getIconName();
            map.remove(s);
            this.mapUploadedSprites.put(s, textureatlassprite1);
            try {
                TextureUtil.uploadTextureMipmap(textureatlassprite1.getFrameTextureData(0), textureatlassprite1.getIconWidth(), textureatlassprite1.getIconHeight(), textureatlassprite1.getOriginX(), textureatlassprite1.getOriginY(), false, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Texture being stitched together");
                crashreportcategory.addCrashSection("Atlas path", this.basePath);
                crashreportcategory.addCrashSection("Sprite", textureatlassprite1);
                throw new ReportedException(crashreport);
            }
            if (!textureatlassprite1.hasAnimationMetadata()) continue;
            this.listAnimatedSprites.add(textureatlassprite1);
        }
        for (TextureAtlasSprite textureatlassprite2 : map.values()) {
            textureatlassprite2.copyFrom(this.missingImage);
        }
        ForgeHooksClient.onTextureStitchedPost(this);
        ProgressManager.pop(bar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateMipmaps(IResourceManager p_generateMipmaps_1_, final TextureAtlasSprite p_generateMipmaps_2_) {
        block10: {
            ResourceLocation resourcelocation = this.getResourceLocation(p_generateMipmaps_2_);
            IResource iresource = null;
            if (!p_generateMipmaps_2_.hasCustomLoader(p_generateMipmaps_1_, resourcelocation)) {
                boolean flag;
                try {
                    iresource = p_generateMipmaps_1_.getResource(resourcelocation);
                    p_generateMipmaps_2_.loadSpriteFrames(iresource, this.mipmapLevels + 1);
                    break block10;
                }
                catch (RuntimeException runtimeexception) {
                    LOGGER.error("Unable to parse metadata from {}", new Object[]{resourcelocation, runtimeexception});
                    flag = false;
                }
                catch (IOException ioexception) {
                    boolean flag2;
                    LOGGER.error("Using missing texture, unable to load {}", new Object[]{resourcelocation, ioexception});
                    boolean bl = flag2 = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iresource);
                }
                return flag;
            }
        }
        try {
            p_generateMipmaps_2_.generateMipmaps(this.mipmapLevels);
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Sprite being mipmapped");
            crashreportcategory.setDetail("Sprite name", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return p_generateMipmaps_2_.getIconName();
                }
            });
            crashreportcategory.setDetail("Sprite size", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return p_generateMipmaps_2_.getIconWidth() + " x " + p_generateMipmaps_2_.getIconHeight();
                }
            });
            crashreportcategory.setDetail("Sprite frames", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return p_generateMipmaps_2_.getFrameCount() + " frames";
                }
            });
            crashreportcategory.addCrashSection("Mipmap levels", this.mipmapLevels);
            throw new ReportedException(crashreport);
        }
    }

    private ResourceLocation getResourceLocation(TextureAtlasSprite p_getResourceLocation_1_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_getResourceLocation_1_.getIconName());
        return new ResourceLocation(resourcelocation.getResourceDomain(), String.format("%s/%s%s", this.basePath, resourcelocation.getResourcePath(), ".png"));
    }

    public TextureAtlasSprite getAtlasSprite(String p_getAtlasSprite_1_) {
        TextureAtlasSprite textureatlassprite = this.mapUploadedSprites.get(p_getAtlasSprite_1_);
        if (textureatlassprite == null) {
            textureatlassprite = this.missingImage;
        }
        return textureatlassprite;
    }

    public void updateAnimations() {
        TextureUtil.bindTexture(this.getGlTextureId());
        for (TextureAtlasSprite textureatlassprite : this.listAnimatedSprites) {
            textureatlassprite.updateAnimation();
        }
    }

    public TextureAtlasSprite registerSprite(ResourceLocation p_registerSprite_1_) {
        if (p_registerSprite_1_ == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        TextureAtlasSprite textureatlassprite = this.mapRegisteredSprites.get(p_registerSprite_1_.toString());
        if (textureatlassprite == null) {
            textureatlassprite = TextureAtlasSprite.makeAtlasSprite(p_registerSprite_1_);
            this.mapRegisteredSprites.put(p_registerSprite_1_.toString(), textureatlassprite);
        }
        return textureatlassprite;
    }

    @Override
    public void tick() {
        this.updateAnimations();
    }

    public void setMipmapLevels(int p_setMipmapLevels_1_) {
        this.mipmapLevels = p_setMipmapLevels_1_;
    }

    public TextureAtlasSprite getMissingSprite() {
        return this.missingImage;
    }

    @Nullable
    public TextureAtlasSprite getTextureExtry(String p_getTextureExtry_1_) {
        return this.mapRegisteredSprites.get(p_getTextureExtry_1_);
    }

    public boolean setTextureEntry(TextureAtlasSprite p_setTextureEntry_1_) {
        String name = p_setTextureEntry_1_.getIconName();
        if (!this.mapRegisteredSprites.containsKey(name)) {
            this.mapRegisteredSprites.put(name, p_setTextureEntry_1_);
            return true;
        }
        return false;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public int getMipmapLevels() {
        return this.mipmapLevels;
    }
}

