/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class TextureUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IntBuffer DATA_BUFFER = GLAllocation.createDirectIntBuffer(0x400000);
    public static final DynamicTexture MISSING_TEXTURE = new DynamicTexture(16, 16);
    public static final int[] MISSING_TEXTURE_DATA = MISSING_TEXTURE.getTextureData();
    private static final float[] COLOR_GAMMAS;
    private static final int[] MIPMAP_BUFFER;

    private static float getColorGamma(int p_getColorGamma_0_) {
        return COLOR_GAMMAS[p_getColorGamma_0_ & 0xFF];
    }

    public static int glGenTextures() {
        return GlStateManager.generateTexture();
    }

    public static void deleteTexture(int p_deleteTexture_0_) {
        GlStateManager.deleteTexture(p_deleteTexture_0_);
    }

    public static int uploadTextureImage(int p_uploadTextureImage_0_, BufferedImage p_uploadTextureImage_1_) {
        return TextureUtil.uploadTextureImageAllocate(p_uploadTextureImage_0_, p_uploadTextureImage_1_, false, false);
    }

    public static void uploadTexture(int p_uploadTexture_0_, int[] p_uploadTexture_1_, int p_uploadTexture_2_, int p_uploadTexture_3_) {
        TextureUtil.bindTexture(p_uploadTexture_0_);
        TextureUtil.uploadTextureSub(0, p_uploadTexture_1_, p_uploadTexture_2_, p_uploadTexture_3_, 0, 0, false, false, false);
    }

    public static int[][] generateMipmapData(int p_generateMipmapData_0_, int p_generateMipmapData_1_, int[][] p_generateMipmapData_2_) {
        int[][] aint = new int[p_generateMipmapData_0_ + 1][];
        aint[0] = p_generateMipmapData_2_[0];
        if (p_generateMipmapData_0_ > 0) {
            boolean flag = false;
            for (int i = 0; i < p_generateMipmapData_2_.length; ++i) {
                if (p_generateMipmapData_2_[0][i] >> 24 != 0) continue;
                flag = true;
                break;
            }
            for (int l1 = 1; l1 <= p_generateMipmapData_0_; ++l1) {
                if (p_generateMipmapData_2_[l1] != null) {
                    aint[l1] = p_generateMipmapData_2_[l1];
                    continue;
                }
                int[] aint1 = aint[l1 - 1];
                int[] aint2 = new int[aint1.length >> 2];
                int j = p_generateMipmapData_1_ >> l1;
                if (j > 0) {
                    int k = aint2.length / j;
                    int l = j << 1;
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            int k1 = 2 * (i1 + j1 * l);
                            aint2[i1 + j1 * j] = TextureUtil.blendColors(aint1[k1 + 0], aint1[k1 + 1], aint1[k1 + 0 + l], aint1[k1 + 1 + l], flag);
                        }
                    }
                }
                aint[l1] = aint2;
            }
        }
        return aint;
    }

    private static int blendColors(int p_blendColors_0_, int p_blendColors_1_, int p_blendColors_2_, int p_blendColors_3_, boolean p_blendColors_4_) {
        if (p_blendColors_4_) {
            TextureUtil.MIPMAP_BUFFER[0] = p_blendColors_0_;
            TextureUtil.MIPMAP_BUFFER[1] = p_blendColors_1_;
            TextureUtil.MIPMAP_BUFFER[2] = p_blendColors_2_;
            TextureUtil.MIPMAP_BUFFER[3] = p_blendColors_3_;
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int i1 = 0; i1 < 4; ++i1) {
                if (MIPMAP_BUFFER[i1] >> 24 == 0) continue;
                f += TextureUtil.getColorGamma(MIPMAP_BUFFER[i1] >> 24);
                f1 += TextureUtil.getColorGamma(MIPMAP_BUFFER[i1] >> 16);
                f2 += TextureUtil.getColorGamma(MIPMAP_BUFFER[i1] >> 8);
                f3 += TextureUtil.getColorGamma(MIPMAP_BUFFER[i1] >> 0);
            }
            int i2 = (int)(Math.pow(f /= 4.0f, 0.45454545454545453) * 255.0);
            int j1 = (int)(Math.pow(f1 /= 4.0f, 0.45454545454545453) * 255.0);
            int k1 = (int)(Math.pow(f2 /= 4.0f, 0.45454545454545453) * 255.0);
            int l1 = (int)(Math.pow(f3 /= 4.0f, 0.45454545454545453) * 255.0);
            if (i2 < 96) {
                i2 = 0;
            }
            return i2 << 24 | j1 << 16 | k1 << 8 | l1;
        }
        int i = TextureUtil.blendColorComponent(p_blendColors_0_, p_blendColors_1_, p_blendColors_2_, p_blendColors_3_, 24);
        int j = TextureUtil.blendColorComponent(p_blendColors_0_, p_blendColors_1_, p_blendColors_2_, p_blendColors_3_, 16);
        int k = TextureUtil.blendColorComponent(p_blendColors_0_, p_blendColors_1_, p_blendColors_2_, p_blendColors_3_, 8);
        int l = TextureUtil.blendColorComponent(p_blendColors_0_, p_blendColors_1_, p_blendColors_2_, p_blendColors_3_, 0);
        return i << 24 | j << 16 | k << 8 | l;
    }

    private static int blendColorComponent(int p_blendColorComponent_0_, int p_blendColorComponent_1_, int p_blendColorComponent_2_, int p_blendColorComponent_3_, int p_blendColorComponent_4_) {
        float f = TextureUtil.getColorGamma(p_blendColorComponent_0_ >> p_blendColorComponent_4_);
        float f1 = TextureUtil.getColorGamma(p_blendColorComponent_1_ >> p_blendColorComponent_4_);
        float f2 = TextureUtil.getColorGamma(p_blendColorComponent_2_ >> p_blendColorComponent_4_);
        float f3 = TextureUtil.getColorGamma(p_blendColorComponent_3_ >> p_blendColorComponent_4_);
        float f4 = (float)((double)((float)Math.pow((double)(f + f1 + f2 + f3) * 0.25, 0.45454545454545453)));
        return (int)((double)f4 * 255.0);
    }

    public static void uploadTextureMipmap(int[][] p_uploadTextureMipmap_0_, int p_uploadTextureMipmap_1_, int p_uploadTextureMipmap_2_, int p_uploadTextureMipmap_3_, int p_uploadTextureMipmap_4_, boolean p_uploadTextureMipmap_5_, boolean p_uploadTextureMipmap_6_) {
        for (int i = 0; i < p_uploadTextureMipmap_0_.length; ++i) {
            int[] aint = p_uploadTextureMipmap_0_[i];
            if (p_uploadTextureMipmap_1_ >> i <= 0 || p_uploadTextureMipmap_2_ >> i <= 0) break;
            TextureUtil.uploadTextureSub(i, aint, p_uploadTextureMipmap_1_ >> i, p_uploadTextureMipmap_2_ >> i, p_uploadTextureMipmap_3_ >> i, p_uploadTextureMipmap_4_ >> i, p_uploadTextureMipmap_5_, p_uploadTextureMipmap_6_, p_uploadTextureMipmap_0_.length > 1);
        }
    }

    private static void uploadTextureSub(int p_uploadTextureSub_0_, int[] p_uploadTextureSub_1_, int p_uploadTextureSub_2_, int p_uploadTextureSub_3_, int p_uploadTextureSub_4_, int p_uploadTextureSub_5_, boolean p_uploadTextureSub_6_, boolean p_uploadTextureSub_7_, boolean p_uploadTextureSub_8_) {
        int l;
        int i = 0x400000 / p_uploadTextureSub_2_;
        TextureUtil.setTextureBlurMipmap(p_uploadTextureSub_6_, p_uploadTextureSub_8_);
        TextureUtil.setTextureClamped(p_uploadTextureSub_7_);
        for (int j = 0; j < p_uploadTextureSub_2_ * p_uploadTextureSub_3_; j += p_uploadTextureSub_2_ * l) {
            int k = j / p_uploadTextureSub_2_;
            l = Math.min(i, p_uploadTextureSub_3_ - k);
            int i1 = p_uploadTextureSub_2_ * l;
            TextureUtil.copyToBufferPos(p_uploadTextureSub_1_, j, i1);
            GlStateManager.glTexSubImage2D(3553, p_uploadTextureSub_0_, p_uploadTextureSub_4_, p_uploadTextureSub_5_ + k, p_uploadTextureSub_2_, l, 32993, 33639, DATA_BUFFER);
        }
    }

    public static int uploadTextureImageAllocate(int p_uploadTextureImageAllocate_0_, BufferedImage p_uploadTextureImageAllocate_1_, boolean p_uploadTextureImageAllocate_2_, boolean p_uploadTextureImageAllocate_3_) {
        TextureUtil.allocateTexture(p_uploadTextureImageAllocate_0_, p_uploadTextureImageAllocate_1_.getWidth(), p_uploadTextureImageAllocate_1_.getHeight());
        return TextureUtil.uploadTextureImageSub(p_uploadTextureImageAllocate_0_, p_uploadTextureImageAllocate_1_, 0, 0, p_uploadTextureImageAllocate_2_, p_uploadTextureImageAllocate_3_);
    }

    public static void allocateTexture(int p_allocateTexture_0_, int p_allocateTexture_1_, int p_allocateTexture_2_) {
        TextureUtil.allocateTextureImpl(p_allocateTexture_0_, 0, p_allocateTexture_1_, p_allocateTexture_2_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allocateTextureImpl(int p_allocateTextureImpl_0_, int p_allocateTextureImpl_1_, int p_allocateTextureImpl_2_, int p_allocateTextureImpl_3_) {
        Class<SplashProgress> clazz = SplashProgress.class;
        synchronized (SplashProgress.class) {
            TextureUtil.deleteTexture(p_allocateTextureImpl_0_);
            TextureUtil.bindTexture(p_allocateTextureImpl_0_);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (p_allocateTextureImpl_1_ >= 0) {
                GlStateManager.glTexParameteri(3553, 33085, p_allocateTextureImpl_1_);
                GlStateManager.glTexParameteri(3553, 33082, 0);
                GlStateManager.glTexParameteri(3553, 33083, p_allocateTextureImpl_1_);
                GlStateManager.glTexParameterf(3553, 34049, 0.0f);
            }
            for (int i = 0; i <= p_allocateTextureImpl_1_; ++i) {
                GlStateManager.glTexImage2D(3553, i, 6408, p_allocateTextureImpl_2_ >> i, p_allocateTextureImpl_3_ >> i, 0, 32993, 33639, null);
            }
            return;
        }
    }

    public static int uploadTextureImageSub(int p_uploadTextureImageSub_0_, BufferedImage p_uploadTextureImageSub_1_, int p_uploadTextureImageSub_2_, int p_uploadTextureImageSub_3_, boolean p_uploadTextureImageSub_4_, boolean p_uploadTextureImageSub_5_) {
        TextureUtil.bindTexture(p_uploadTextureImageSub_0_);
        TextureUtil.uploadTextureImageSubImpl(p_uploadTextureImageSub_1_, p_uploadTextureImageSub_2_, p_uploadTextureImageSub_3_, p_uploadTextureImageSub_4_, p_uploadTextureImageSub_5_);
        return p_uploadTextureImageSub_0_;
    }

    private static void uploadTextureImageSubImpl(BufferedImage p_uploadTextureImageSubImpl_0_, int p_uploadTextureImageSubImpl_1_, int p_uploadTextureImageSubImpl_2_, boolean p_uploadTextureImageSubImpl_3_, boolean p_uploadTextureImageSubImpl_4_) {
        int i = p_uploadTextureImageSubImpl_0_.getWidth();
        int j = p_uploadTextureImageSubImpl_0_.getHeight();
        int k = 0x400000 / i;
        int[] aint = new int[k * i];
        TextureUtil.setTextureBlurred(p_uploadTextureImageSubImpl_3_);
        TextureUtil.setTextureClamped(p_uploadTextureImageSubImpl_4_);
        for (int l = 0; l < i * j; l += i * k) {
            int i1 = l / i;
            int j1 = Math.min(k, j - i1);
            int k1 = i * j1;
            p_uploadTextureImageSubImpl_0_.getRGB(0, i1, i, j1, aint, 0, i);
            TextureUtil.copyToBuffer(aint, k1);
            GlStateManager.glTexSubImage2D(3553, 0, p_uploadTextureImageSubImpl_1_, p_uploadTextureImageSubImpl_2_ + i1, i, j1, 32993, 33639, DATA_BUFFER);
        }
    }

    private static void setTextureClamped(boolean p_setTextureClamped_0_) {
        if (p_setTextureClamped_0_) {
            GlStateManager.glTexParameteri(3553, 10242, 10496);
            GlStateManager.glTexParameteri(3553, 10243, 10496);
        } else {
            GlStateManager.glTexParameteri(3553, 10242, 10497);
            GlStateManager.glTexParameteri(3553, 10243, 10497);
        }
    }

    private static void setTextureBlurred(boolean p_setTextureBlurred_0_) {
        TextureUtil.setTextureBlurMipmap(p_setTextureBlurred_0_, false);
    }

    private static void setTextureBlurMipmap(boolean p_setTextureBlurMipmap_0_, boolean p_setTextureBlurMipmap_1_) {
        if (p_setTextureBlurMipmap_0_) {
            GlStateManager.glTexParameteri(3553, 10241, p_setTextureBlurMipmap_1_ ? 9987 : 9729);
            GlStateManager.glTexParameteri(3553, 10240, 9729);
        } else {
            GlStateManager.glTexParameteri(3553, 10241, p_setTextureBlurMipmap_1_ ? 9986 : 9728);
            GlStateManager.glTexParameteri(3553, 10240, 9728);
        }
    }

    private static void copyToBuffer(int[] p_copyToBuffer_0_, int p_copyToBuffer_1_) {
        TextureUtil.copyToBufferPos(p_copyToBuffer_0_, 0, p_copyToBuffer_1_);
    }

    private static void copyToBufferPos(int[] p_copyToBufferPos_0_, int p_copyToBufferPos_1_, int p_copyToBufferPos_2_) {
        int[] aint = p_copyToBufferPos_0_;
        if (Minecraft.getMinecraft().gameSettings.anaglyph) {
            aint = TextureUtil.updateAnaglyph(p_copyToBufferPos_0_);
        }
        DATA_BUFFER.clear();
        DATA_BUFFER.put(aint, p_copyToBufferPos_1_, p_copyToBufferPos_2_);
        DATA_BUFFER.position(0).limit(p_copyToBufferPos_2_);
    }

    static void bindTexture(int p_bindTexture_0_) {
        GlStateManager.bindTexture(p_bindTexture_0_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readImageData(IResourceManager p_readImageData_0_, ResourceLocation p_readImageData_1_) throws IOException {
        int[] aint1;
        IResource iresource = null;
        try {
            iresource = p_readImageData_0_.getResource(p_readImageData_1_);
            BufferedImage bufferedimage = TextureUtil.readBufferedImage(iresource.getInputStream());
            int i = bufferedimage.getWidth();
            int j = bufferedimage.getHeight();
            int[] aint = new int[i * j];
            bufferedimage.getRGB(0, 0, i, j, aint, 0, i);
            aint1 = aint;
        }
        finally {
            IOUtils.closeQuietly((Closeable)iresource);
        }
        return aint1;
    }

    public static BufferedImage readBufferedImage(InputStream p_readBufferedImage_0_) throws IOException {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(p_readBufferedImage_0_);
        }
        finally {
            IOUtils.closeQuietly((InputStream)p_readBufferedImage_0_);
        }
        return bufferedimage;
    }

    public static int[] updateAnaglyph(int[] p_updateAnaglyph_0_) {
        int[] aint = new int[p_updateAnaglyph_0_.length];
        for (int i = 0; i < p_updateAnaglyph_0_.length; ++i) {
            aint[i] = TextureUtil.anaglyphColor(p_updateAnaglyph_0_[i]);
        }
        return aint;
    }

    public static int anaglyphColor(int p_anaglyphColor_0_) {
        int i = p_anaglyphColor_0_ >> 24 & 0xFF;
        int j = p_anaglyphColor_0_ >> 16 & 0xFF;
        int k = p_anaglyphColor_0_ >> 8 & 0xFF;
        int l = p_anaglyphColor_0_ & 0xFF;
        int i1 = (j * 30 + k * 59 + l * 11) / 100;
        int j1 = (j * 30 + k * 70) / 100;
        int k1 = (j * 30 + l * 70) / 100;
        return i << 24 | i1 << 16 | j1 << 8 | k1;
    }

    public static void processPixelValues(int[] p_processPixelValues_0_, int p_processPixelValues_1_, int p_processPixelValues_2_) {
        int[] aint = new int[p_processPixelValues_1_];
        int i = p_processPixelValues_2_ / 2;
        for (int j = 0; j < i; ++j) {
            System.arraycopy(p_processPixelValues_0_, j * p_processPixelValues_1_, aint, 0, p_processPixelValues_1_);
            System.arraycopy(p_processPixelValues_0_, (p_processPixelValues_2_ - 1 - j) * p_processPixelValues_1_, p_processPixelValues_0_, j * p_processPixelValues_1_, p_processPixelValues_1_);
            System.arraycopy(aint, 0, p_processPixelValues_0_, (p_processPixelValues_2_ - 1 - j) * p_processPixelValues_1_, p_processPixelValues_1_);
        }
    }

    static {
        int i = -16777216;
        int j = -524040;
        int[] aint = new int[]{-524040, -524040, -524040, -524040, -524040, -524040, -524040, -524040};
        int[] aint1 = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
        int k = aint.length;
        for (int l = 0; l < 16; ++l) {
            System.arraycopy(l < k ? aint : aint1, 0, MISSING_TEXTURE_DATA, 16 * l, k);
            System.arraycopy(l < k ? aint1 : aint, 0, MISSING_TEXTURE_DATA, 16 * l + k, k);
        }
        MISSING_TEXTURE.updateDynamicTexture();
        COLOR_GAMMAS = new float[256];
        for (i = 0; i < COLOR_GAMMAS.length; ++i) {
            TextureUtil.COLOR_GAMMAS[i] = (float)Math.pow((float)i / 255.0f, 2.2);
        }
        MIPMAP_BUFFER = new int[4];
    }
}

