/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelEnderCrystal;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderDragon;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEnderCrystal
extends Render<EntityEnderCrystal> {
    private static final ResourceLocation ENDER_CRYSTAL_TEXTURES = new ResourceLocation("textures/entity/endercrystal/endercrystal.png");
    private final ModelBase modelEnderCrystal = new ModelEnderCrystal(0.0f, true);
    private final ModelBase modelEnderCrystalNoBase = new ModelEnderCrystal(0.0f, false);

    public RenderEnderCrystal(RenderManager p_i46184_1_) {
        super(p_i46184_1_);
        this.shadowSize = 0.5f;
    }

    @Override
    public void doRender(EntityEnderCrystal p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        float lvt_10_1_ = (float)p_doRender_1_.innerRotation + p_doRender_9_;
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)p_doRender_2_, (float)p_doRender_4_, (float)p_doRender_6_);
        this.bindTexture(ENDER_CRYSTAL_TEXTURES);
        float lvt_11_1_ = MathHelper.sin(lvt_10_1_ * 0.2f) / 2.0f + 0.5f;
        lvt_11_1_ = lvt_11_1_ * lvt_11_1_ + lvt_11_1_;
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        if (p_doRender_1_.shouldShowBottom()) {
            this.modelEnderCrystal.render(p_doRender_1_, 0.0f, lvt_10_1_ * 3.0f, lvt_11_1_ * 0.2f, 0.0f, 0.0f, 0.0625f);
        } else {
            this.modelEnderCrystalNoBase.render(p_doRender_1_, 0.0f, lvt_10_1_ * 3.0f, lvt_11_1_ * 0.2f, 0.0f, 0.0f, 0.0625f);
        }
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        BlockPos lvt_12_1_ = p_doRender_1_.getBeamTarget();
        if (lvt_12_1_ != null) {
            this.bindTexture(RenderDragon.ENDERCRYSTAL_BEAM_TEXTURES);
            float lvt_13_1_ = (float)lvt_12_1_.getX() + 0.5f;
            float lvt_14_1_ = (float)lvt_12_1_.getY() + 0.5f;
            float lvt_15_1_ = (float)lvt_12_1_.getZ() + 0.5f;
            double lvt_16_1_ = (double)lvt_13_1_ - p_doRender_1_.posX;
            double lvt_18_1_ = (double)lvt_14_1_ - p_doRender_1_.posY;
            double lvt_20_1_ = (double)lvt_15_1_ - p_doRender_1_.posZ;
            RenderDragon.renderCrystalBeams(p_doRender_2_ + lvt_16_1_, p_doRender_4_ - 0.3 + (double)(lvt_11_1_ * 0.4f) + lvt_18_1_, p_doRender_6_ + lvt_20_1_, p_doRender_9_, lvt_13_1_, lvt_14_1_, lvt_15_1_, p_doRender_1_.innerRotation, p_doRender_1_.posX, p_doRender_1_.posY, p_doRender_1_.posZ);
        }
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityEnderCrystal p_getEntityTexture_1_) {
        return ENDER_CRYSTAL_TEXTURES;
    }

    @Override
    public boolean shouldRender(EntityEnderCrystal p_shouldRender_1_, ICamera p_shouldRender_2_, double p_shouldRender_3_, double p_shouldRender_5_, double p_shouldRender_7_) {
        return super.shouldRender(p_shouldRender_1_, p_shouldRender_2_, p_shouldRender_3_, p_shouldRender_5_, p_shouldRender_7_) || p_shouldRender_1_.getBeamTarget() != null;
    }
}

