/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderItemFrame
extends Render<EntityItemFrame> {
    private static final ResourceLocation MAP_BACKGROUND_TEXTURES = new ResourceLocation("textures/map/map_background.png");
    private final Minecraft mc = Minecraft.getMinecraft();
    private final ModelResourceLocation itemFrameModel = new ModelResourceLocation("item_frame", "normal");
    private final ModelResourceLocation mapModel = new ModelResourceLocation("item_frame", "map");
    private final RenderItem itemRenderer;

    public RenderItemFrame(RenderManager p_i46166_1_, RenderItem p_i46166_2_) {
        super(p_i46166_1_);
        this.itemRenderer = p_i46166_2_;
    }

    @Override
    public void doRender(EntityItemFrame p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        GlStateManager.pushMatrix();
        BlockPos blockpos = p_doRender_1_.getHangingPosition();
        double d0 = (double)blockpos.getX() - p_doRender_1_.posX + p_doRender_2_;
        double d1 = (double)blockpos.getY() - p_doRender_1_.posY + p_doRender_4_;
        double d2 = (double)blockpos.getZ() - p_doRender_1_.posZ + p_doRender_6_;
        GlStateManager.translate(d0 + 0.5, d1 + 0.5, d2 + 0.5);
        GlStateManager.rotate(180.0f - p_doRender_1_.rotationYaw, 0.0f, 1.0f, 0.0f);
        this.renderManager.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        BlockRendererDispatcher blockrendererdispatcher = this.mc.getBlockRendererDispatcher();
        ModelManager modelmanager = blockrendererdispatcher.getBlockModelShapes().getModelManager();
        IBakedModel ibakedmodel = !p_doRender_1_.getDisplayedItem().isEmpty() && p_doRender_1_.getDisplayedItem().getItem() == Items.FILLED_MAP ? modelmanager.getModel(this.mapModel) : modelmanager.getModel(this.itemFrameModel);
        GlStateManager.pushMatrix();
        GlStateManager.translate(-0.5f, -0.5f, -0.5f);
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        blockrendererdispatcher.getBlockModelRenderer().renderModelBrightnessColor(ibakedmodel, 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        GlStateManager.translate(0.0f, 0.0f, 0.4375f);
        this.renderItem(p_doRender_1_);
        GlStateManager.popMatrix();
        this.renderName(p_doRender_1_, p_doRender_2_ + (double)((float)p_doRender_1_.facingDirection.getFrontOffsetX() * 0.3f), p_doRender_4_ - 0.25, p_doRender_6_ + (double)((float)p_doRender_1_.facingDirection.getFrontOffsetZ() * 0.3f));
    }

    @Override
    @Nullable
    protected ResourceLocation getEntityTexture(EntityItemFrame p_getEntityTexture_1_) {
        return null;
    }

    private void renderItem(EntityItemFrame p_renderItem_1_) {
        ItemStack itemstack = p_renderItem_1_.getDisplayedItem();
        if (!itemstack.isEmpty()) {
            EntityItem entityitem = new EntityItem(p_renderItem_1_.world, 0.0, 0.0, 0.0, itemstack);
            Item item = entityitem.getEntityItem().getItem();
            entityitem.getEntityItem().setCount(1);
            entityitem.hoverStart = 0.0f;
            GlStateManager.pushMatrix();
            GlStateManager.disableLighting();
            int i = p_renderItem_1_.getRotation();
            if (item instanceof ItemMap) {
                i = i % 4 * 2;
            }
            GlStateManager.rotate((float)i * 360.0f / 8.0f, 0.0f, 0.0f, 1.0f);
            RenderItemInFrameEvent event = new RenderItemInFrameEvent(p_renderItem_1_, this);
            if (!MinecraftForge.EVENT_BUS.post(event)) {
                if (item instanceof ItemMap) {
                    this.renderManager.renderEngine.bindTexture(MAP_BACKGROUND_TEXTURES);
                    GlStateManager.rotate(180.0f, 0.0f, 0.0f, 1.0f);
                    float f = 0.0078125f;
                    GlStateManager.scale(0.0078125f, 0.0078125f, 0.0078125f);
                    GlStateManager.translate(-64.0f, -64.0f, 0.0f);
                    MapData mapdata = Items.FILLED_MAP.getMapData(entityitem.getEntityItem(), p_renderItem_1_.world);
                    GlStateManager.translate(0.0f, 0.0f, -1.0f);
                    if (mapdata != null) {
                        this.mc.entityRenderer.getMapItemRenderer().renderMap(mapdata, true);
                    }
                } else {
                    GlStateManager.scale(0.5f, 0.5f, 0.5f);
                    GlStateManager.pushAttrib();
                    RenderHelper.enableStandardItemLighting();
                    this.itemRenderer.renderItem(entityitem.getEntityItem(), ItemCameraTransforms.TransformType.FIXED);
                    RenderHelper.disableStandardItemLighting();
                    GlStateManager.popAttrib();
                }
            }
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
    }

    @Override
    protected void renderName(EntityItemFrame p_renderName_1_, double p_renderName_2_, double p_renderName_4_, double p_renderName_6_) {
        if (Minecraft.isGuiEnabled() && !p_renderName_1_.getDisplayedItem().isEmpty() && p_renderName_1_.getDisplayedItem().hasDisplayName() && this.renderManager.pointedEntity == p_renderName_1_) {
            float f;
            double d0 = p_renderName_1_.getDistanceSqToEntity(this.renderManager.renderViewEntity);
            float f2 = f = p_renderName_1_.isSneaking() ? 32.0f : 64.0f;
            if (d0 < (double)(f * f)) {
                String s = p_renderName_1_.getDisplayedItem().getDisplayName();
                this.renderLivingLabel(p_renderName_1_, s, p_renderName_2_, p_renderName_4_, p_renderName_6_, 64);
            }
        }
    }
}

