/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWitherSkull
extends Render<EntityWitherSkull> {
    private static final ResourceLocation INVULNERABLE_WITHER_TEXTURES = new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_TEXTURES = new ResourceLocation("textures/entity/wither/wither.png");
    private final ModelSkeletonHead skeletonHeadModel = new ModelSkeletonHead();

    public RenderWitherSkull(RenderManager p_i46129_1_) {
        super(p_i46129_1_);
    }

    private float getRenderYaw(float p_getRenderYaw_1_, float p_getRenderYaw_2_, float p_getRenderYaw_3_) {
        float lvt_4_1_;
        for (lvt_4_1_ = p_getRenderYaw_2_ - p_getRenderYaw_1_; lvt_4_1_ < -180.0f; lvt_4_1_ += 360.0f) {
        }
        while (lvt_4_1_ >= 180.0f) {
            lvt_4_1_ -= 360.0f;
        }
        return p_getRenderYaw_1_ + p_getRenderYaw_3_ * lvt_4_1_;
    }

    @Override
    public void doRender(EntityWitherSkull p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        float lvt_10_1_ = this.getRenderYaw(p_doRender_1_.prevRotationYaw, p_doRender_1_.rotationYaw, p_doRender_9_);
        float lvt_11_1_ = p_doRender_1_.prevRotationPitch + (p_doRender_1_.rotationPitch - p_doRender_1_.prevRotationPitch) * p_doRender_9_;
        GlStateManager.translate((float)p_doRender_2_, (float)p_doRender_4_, (float)p_doRender_6_);
        float lvt_12_1_ = 0.0625f;
        GlStateManager.enableRescaleNormal();
        GlStateManager.scale(-1.0f, -1.0f, 1.0f);
        GlStateManager.enableAlpha();
        this.bindEntityTexture(p_doRender_1_);
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        this.skeletonHeadModel.render(p_doRender_1_, 0.0f, 0.0f, 0.0f, lvt_10_1_, lvt_11_1_, 0.0625f);
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityWitherSkull p_getEntityTexture_1_) {
        return p_getEntityTexture_1_.isInvulnerable() ? INVULNERABLE_WITHER_TEXTURES : WITHER_TEXTURES;
    }
}

