/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBanner;
import net.minecraft.client.renderer.BannerTextures;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityBannerRenderer
extends TileEntitySpecialRenderer<TileEntityBanner> {
    private final ModelBanner bannerModel = new ModelBanner();

    @Override
    public void renderTileEntityAt(TileEntityBanner p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_, int p_renderTileEntityAt_9_) {
        boolean lvt_10_1_ = p_renderTileEntityAt_1_.getWorld() != null;
        boolean lvt_11_1_ = !lvt_10_1_ || p_renderTileEntityAt_1_.getBlockType() == Blocks.STANDING_BANNER;
        int lvt_12_1_ = lvt_10_1_ ? p_renderTileEntityAt_1_.getBlockMetadata() : 0;
        long lvt_13_1_ = lvt_10_1_ ? p_renderTileEntityAt_1_.getWorld().getTotalWorldTime() : 0L;
        GlStateManager.pushMatrix();
        float lvt_15_1_ = 0.6666667f;
        if (lvt_11_1_) {
            GlStateManager.translate((float)p_renderTileEntityAt_2_ + 0.5f, (float)p_renderTileEntityAt_4_ + 0.5f, (float)p_renderTileEntityAt_6_ + 0.5f);
            float lvt_16_1_ = (float)(lvt_12_1_ * 360) / 16.0f;
            GlStateManager.rotate(-lvt_16_1_, 0.0f, 1.0f, 0.0f);
            this.bannerModel.bannerStand.showModel = true;
        } else {
            int lvt_16_2_ = lvt_12_1_;
            float lvt_17_1_ = 0.0f;
            if (lvt_16_2_ == 2) {
                lvt_17_1_ = 180.0f;
            }
            if (lvt_16_2_ == 4) {
                lvt_17_1_ = 90.0f;
            }
            if (lvt_16_2_ == 5) {
                lvt_17_1_ = -90.0f;
            }
            GlStateManager.translate((float)p_renderTileEntityAt_2_ + 0.5f, (float)p_renderTileEntityAt_4_ - 0.16666667f, (float)p_renderTileEntityAt_6_ + 0.5f);
            GlStateManager.rotate(-lvt_17_1_, 0.0f, 1.0f, 0.0f);
            GlStateManager.translate(0.0f, -0.3125f, -0.4375f);
            this.bannerModel.bannerStand.showModel = false;
        }
        BlockPos lvt_16_3_ = p_renderTileEntityAt_1_.getPos();
        float lvt_17_2_ = (float)(lvt_16_3_.getX() * 7 + lvt_16_3_.getY() * 9 + lvt_16_3_.getZ() * 13) + (float)lvt_13_1_ + p_renderTileEntityAt_8_;
        this.bannerModel.bannerSlate.rotateAngleX = (-0.0125f + 0.01f * MathHelper.cos(lvt_17_2_ * (float)Math.PI * 0.02f)) * (float)Math.PI;
        GlStateManager.enableRescaleNormal();
        ResourceLocation lvt_18_1_ = this.getBannerResourceLocation(p_renderTileEntityAt_1_);
        if (lvt_18_1_ != null) {
            this.bindTexture(lvt_18_1_);
            GlStateManager.pushMatrix();
            GlStateManager.scale(0.6666667f, -0.6666667f, -0.6666667f);
            this.bannerModel.renderBanner();
            GlStateManager.popMatrix();
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.popMatrix();
    }

    @Nullable
    private ResourceLocation getBannerResourceLocation(TileEntityBanner p_getBannerResourceLocation_1_) {
        return BannerTextures.BANNER_DESIGNS.getResourceLocation(p_getBannerResourceLocation_1_.getPatternResourceLocation(), p_getBannerResourceLocation_1_.getPatternList(), p_getBannerResourceLocation_1_.getColorList());
    }
}

