/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import java.util.Calendar;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityChestRenderer
extends TileEntitySpecialRenderer<TileEntityChest> {
    private static final ResourceLocation TEXTURE_TRAPPED_DOUBLE = new ResourceLocation("textures/entity/chest/trapped_double.png");
    private static final ResourceLocation TEXTURE_CHRISTMAS_DOUBLE = new ResourceLocation("textures/entity/chest/christmas_double.png");
    private static final ResourceLocation TEXTURE_NORMAL_DOUBLE = new ResourceLocation("textures/entity/chest/normal_double.png");
    private static final ResourceLocation TEXTURE_TRAPPED = new ResourceLocation("textures/entity/chest/trapped.png");
    private static final ResourceLocation TEXTURE_CHRISTMAS = new ResourceLocation("textures/entity/chest/christmas.png");
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("textures/entity/chest/normal.png");
    private final ModelChest simpleChest = new ModelChest();
    private final ModelChest largeChest = new ModelLargeChest();
    private boolean isChristmas;

    public TileEntityChestRenderer() {
        Calendar lvt_1_1_ = Calendar.getInstance();
        if (lvt_1_1_.get(2) + 1 == 12 && lvt_1_1_.get(5) >= 24 && lvt_1_1_.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    @Override
    public void renderTileEntityAt(TileEntityChest p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_, int p_renderTileEntityAt_9_) {
        float lvt_14_2_;
        float lvt_14_1_;
        ModelChest lvt_11_3_;
        int lvt_10_2_;
        GlStateManager.enableDepth();
        GlStateManager.depthFunc(515);
        GlStateManager.depthMask(true);
        if (p_renderTileEntityAt_1_.hasWorld()) {
            Block lvt_11_1_ = p_renderTileEntityAt_1_.getBlockType();
            int lvt_10_1_ = p_renderTileEntityAt_1_.getBlockMetadata();
            if (lvt_11_1_ instanceof BlockChest && lvt_10_1_ == 0) {
                ((BlockChest)lvt_11_1_).checkForSurroundingChests(p_renderTileEntityAt_1_.getWorld(), p_renderTileEntityAt_1_.getPos(), p_renderTileEntityAt_1_.getWorld().getBlockState(p_renderTileEntityAt_1_.getPos()));
                lvt_10_1_ = p_renderTileEntityAt_1_.getBlockMetadata();
            }
            p_renderTileEntityAt_1_.checkForAdjacentChests();
        } else {
            lvt_10_2_ = 0;
        }
        if (p_renderTileEntityAt_1_.adjacentChestZNeg != null || p_renderTileEntityAt_1_.adjacentChestXNeg != null) {
            return;
        }
        if (p_renderTileEntityAt_1_.adjacentChestXPos != null || p_renderTileEntityAt_1_.adjacentChestZPos != null) {
            ModelChest lvt_11_2_ = this.largeChest;
            if (p_renderTileEntityAt_9_ >= 0) {
                this.bindTexture(DESTROY_STAGES[p_renderTileEntityAt_9_]);
                GlStateManager.matrixMode(5890);
                GlStateManager.pushMatrix();
                GlStateManager.scale(8.0f, 4.0f, 1.0f);
                GlStateManager.translate(0.0625f, 0.0625f, 0.0625f);
                GlStateManager.matrixMode(5888);
            } else if (this.isChristmas) {
                this.bindTexture(TEXTURE_CHRISTMAS_DOUBLE);
            } else if (p_renderTileEntityAt_1_.getChestType() == BlockChest.Type.TRAP) {
                this.bindTexture(TEXTURE_TRAPPED_DOUBLE);
            } else {
                this.bindTexture(TEXTURE_NORMAL_DOUBLE);
            }
        } else {
            lvt_11_3_ = this.simpleChest;
            if (p_renderTileEntityAt_9_ >= 0) {
                this.bindTexture(DESTROY_STAGES[p_renderTileEntityAt_9_]);
                GlStateManager.matrixMode(5890);
                GlStateManager.pushMatrix();
                GlStateManager.scale(4.0f, 4.0f, 1.0f);
                GlStateManager.translate(0.0625f, 0.0625f, 0.0625f);
                GlStateManager.matrixMode(5888);
            } else if (this.isChristmas) {
                this.bindTexture(TEXTURE_CHRISTMAS);
            } else if (p_renderTileEntityAt_1_.getChestType() == BlockChest.Type.TRAP) {
                this.bindTexture(TEXTURE_TRAPPED);
            } else {
                this.bindTexture(TEXTURE_NORMAL);
            }
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        if (p_renderTileEntityAt_9_ < 0) {
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
        GlStateManager.translate((float)p_renderTileEntityAt_2_, (float)p_renderTileEntityAt_4_ + 1.0f, (float)p_renderTileEntityAt_6_ + 1.0f);
        GlStateManager.scale(1.0f, -1.0f, -1.0f);
        GlStateManager.translate(0.5f, 0.5f, 0.5f);
        int lvt_12_1_ = 0;
        if (lvt_10_2_ == 2) {
            lvt_12_1_ = 180;
        }
        if (lvt_10_2_ == 3) {
            lvt_12_1_ = 0;
        }
        if (lvt_10_2_ == 4) {
            lvt_12_1_ = 90;
        }
        if (lvt_10_2_ == 5) {
            lvt_12_1_ = -90;
        }
        if (lvt_10_2_ == 2 && p_renderTileEntityAt_1_.adjacentChestXPos != null) {
            GlStateManager.translate(1.0f, 0.0f, 0.0f);
        }
        if (lvt_10_2_ == 5 && p_renderTileEntityAt_1_.adjacentChestZPos != null) {
            GlStateManager.translate(0.0f, 0.0f, -1.0f);
        }
        GlStateManager.rotate(lvt_12_1_, 0.0f, 1.0f, 0.0f);
        GlStateManager.translate(-0.5f, -0.5f, -0.5f);
        float lvt_13_1_ = p_renderTileEntityAt_1_.prevLidAngle + (p_renderTileEntityAt_1_.lidAngle - p_renderTileEntityAt_1_.prevLidAngle) * p_renderTileEntityAt_8_;
        if (p_renderTileEntityAt_1_.adjacentChestZNeg != null && (lvt_14_1_ = p_renderTileEntityAt_1_.adjacentChestZNeg.prevLidAngle + (p_renderTileEntityAt_1_.adjacentChestZNeg.lidAngle - p_renderTileEntityAt_1_.adjacentChestZNeg.prevLidAngle) * p_renderTileEntityAt_8_) > lvt_13_1_) {
            lvt_13_1_ = lvt_14_1_;
        }
        if (p_renderTileEntityAt_1_.adjacentChestXNeg != null && (lvt_14_2_ = p_renderTileEntityAt_1_.adjacentChestXNeg.prevLidAngle + (p_renderTileEntityAt_1_.adjacentChestXNeg.lidAngle - p_renderTileEntityAt_1_.adjacentChestXNeg.prevLidAngle) * p_renderTileEntityAt_8_) > lvt_13_1_) {
            lvt_13_1_ = lvt_14_2_;
        }
        lvt_13_1_ = 1.0f - lvt_13_1_;
        lvt_13_1_ = 1.0f - lvt_13_1_ * lvt_13_1_ * lvt_13_1_;
        lvt_11_3_.chestLid.rotateAngleX = -(lvt_13_1_ * 1.5707964f);
        lvt_11_3_.renderAll();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (p_renderTileEntityAt_9_ >= 0) {
            GlStateManager.matrixMode(5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5888);
        }
    }
}

