/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityEndPortalRenderer;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityEndGatewayRenderer
extends TileEntityEndPortalRenderer {
    private static final ResourceLocation END_GATEWAY_BEAM_TEXTURE = new ResourceLocation("textures/entity/end_gateway_beam.png");

    @Override
    public void renderTileEntityAt(TileEntityEndPortal p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_, int p_renderTileEntityAt_9_) {
        GlStateManager.disableFog();
        TileEntityEndGateway lvt_10_1_ = (TileEntityEndGateway)p_renderTileEntityAt_1_;
        if (lvt_10_1_.isSpawning() || lvt_10_1_.isCoolingDown()) {
            GlStateManager.alphaFunc(516, 0.1f);
            this.bindTexture(END_GATEWAY_BEAM_TEXTURE);
            float lvt_11_1_ = lvt_10_1_.isSpawning() ? lvt_10_1_.getSpawnPercent(p_renderTileEntityAt_8_) : lvt_10_1_.getCooldownPercent(p_renderTileEntityAt_8_);
            double lvt_12_1_ = lvt_10_1_.isSpawning() ? 256.0 - p_renderTileEntityAt_4_ : 50.0;
            lvt_11_1_ = MathHelper.sin(lvt_11_1_ * (float)Math.PI);
            int lvt_14_1_ = MathHelper.floor((double)lvt_11_1_ * lvt_12_1_);
            float[] lvt_15_1_ = EntitySheep.getDyeRgb(lvt_10_1_.isSpawning() ? EnumDyeColor.MAGENTA : EnumDyeColor.PURPLE);
            TileEntityBeaconRenderer.renderBeamSegment(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_, p_renderTileEntityAt_8_, lvt_11_1_, lvt_10_1_.getWorld().getTotalWorldTime(), 0, lvt_14_1_, lvt_15_1_, 0.15, 0.175);
            TileEntityBeaconRenderer.renderBeamSegment(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_, p_renderTileEntityAt_8_, lvt_11_1_, lvt_10_1_.getWorld().getTotalWorldTime(), 0, -lvt_14_1_, lvt_15_1_, 0.15, 0.175);
        }
        super.renderTileEntityAt(p_renderTileEntityAt_1_, p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_, p_renderTileEntityAt_8_, p_renderTileEntityAt_9_);
        GlStateManager.enableFog();
    }

    @Override
    protected int getPasses(double p_getPasses_1_) {
        return super.getPasses(p_getPasses_1_) + 1;
    }

    @Override
    protected float getOffset() {
        return 1.0f;
    }
}

