/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityEndPortalRenderer
extends TileEntitySpecialRenderer<TileEntityEndPortal> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.createDirectFloatBuffer(16);
    private static final FloatBuffer PROJECTION = GLAllocation.createDirectFloatBuffer(16);
    private FloatBuffer buffer = GLAllocation.createDirectFloatBuffer(16);

    @Override
    public void renderTileEntityAt(TileEntityEndPortal p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_, int p_renderTileEntityAt_9_) {
        GlStateManager.disableLighting();
        RANDOM.setSeed(31100L);
        GlStateManager.getFloat(2982, MODELVIEW);
        GlStateManager.getFloat(2983, PROJECTION);
        double lvt_10_1_ = p_renderTileEntityAt_2_ * p_renderTileEntityAt_2_ + p_renderTileEntityAt_4_ * p_renderTileEntityAt_4_ + p_renderTileEntityAt_6_ * p_renderTileEntityAt_6_;
        int lvt_12_1_ = this.getPasses(lvt_10_1_);
        float lvt_13_1_ = this.getOffset();
        boolean lvt_14_1_ = false;
        for (int lvt_15_1_ = 0; lvt_15_1_ < lvt_12_1_; ++lvt_15_1_) {
            GlStateManager.pushMatrix();
            float lvt_16_1_ = 2.0f / (float)(18 - lvt_15_1_);
            if (lvt_15_1_ == 0) {
                this.bindTexture(END_SKY_TEXTURE);
                lvt_16_1_ = 0.15f;
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (lvt_15_1_ >= 1) {
                this.bindTexture(END_PORTAL_TEXTURE);
                lvt_14_1_ = true;
                Minecraft.getMinecraft().entityRenderer.func_191514_d(true);
            }
            if (lvt_15_1_ == 1) {
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE);
            }
            GlStateManager.texGen(GlStateManager.TexGen.S, 9216);
            GlStateManager.texGen(GlStateManager.TexGen.T, 9216);
            GlStateManager.texGen(GlStateManager.TexGen.R, 9216);
            GlStateManager.texGen(GlStateManager.TexGen.S, 9474, this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.texGen(GlStateManager.TexGen.T, 9474, this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.texGen(GlStateManager.TexGen.R, 9474, this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.enableTexGenCoord(GlStateManager.TexGen.S);
            GlStateManager.enableTexGenCoord(GlStateManager.TexGen.T);
            GlStateManager.enableTexGenCoord(GlStateManager.TexGen.R);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5890);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.translate(0.5f, 0.5f, 0.0f);
            GlStateManager.scale(0.5f, 0.5f, 1.0f);
            float lvt_17_1_ = lvt_15_1_ + 1;
            GlStateManager.translate(17.0f / lvt_17_1_, (2.0f + lvt_17_1_ / 1.5f) * ((float)Minecraft.getSystemTime() % 800000.0f / 800000.0f), 0.0f);
            GlStateManager.rotate((lvt_17_1_ * lvt_17_1_ * 4321.0f + lvt_17_1_ * 9.0f) * 2.0f, 0.0f, 0.0f, 1.0f);
            GlStateManager.scale(4.5f - lvt_17_1_ / 4.0f, 4.5f - lvt_17_1_ / 4.0f, 1.0f);
            GlStateManager.multMatrix(PROJECTION);
            GlStateManager.multMatrix(MODELVIEW);
            Tessellator lvt_18_1_ = Tessellator.getInstance();
            VertexBuffer lvt_19_1_ = lvt_18_1_.getBuffer();
            lvt_19_1_.begin(7, DefaultVertexFormats.POSITION_COLOR);
            float lvt_20_1_ = (RANDOM.nextFloat() * 0.5f + 0.1f) * lvt_16_1_;
            float lvt_21_1_ = (RANDOM.nextFloat() * 0.5f + 0.4f) * lvt_16_1_;
            float lvt_22_1_ = (RANDOM.nextFloat() * 0.5f + 0.5f) * lvt_16_1_;
            if (p_renderTileEntityAt_1_.shouldRenderFace(EnumFacing.SOUTH)) {
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_ + 1.0, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_ + 1.0, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
            }
            if (p_renderTileEntityAt_1_.shouldRenderFace(EnumFacing.NORTH)) {
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_ + 1.0, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_ + 1.0, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
            }
            if (p_renderTileEntityAt_1_.shouldRenderFace(EnumFacing.EAST)) {
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_ + 1.0, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_ + 1.0, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
            }
            if (p_renderTileEntityAt_1_.shouldRenderFace(EnumFacing.WEST)) {
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_ + 1.0, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_ + 1.0, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
            }
            if (p_renderTileEntityAt_1_.shouldRenderFace(EnumFacing.DOWN)) {
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
            }
            if (p_renderTileEntityAt_1_.shouldRenderFace(EnumFacing.UP)) {
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_ + (double)lvt_13_1_, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_ + (double)lvt_13_1_, p_renderTileEntityAt_6_ + 1.0).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_ + 1.0, p_renderTileEntityAt_4_ + (double)lvt_13_1_, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
                lvt_19_1_.pos(p_renderTileEntityAt_2_, p_renderTileEntityAt_4_ + (double)lvt_13_1_, p_renderTileEntityAt_6_).color(lvt_20_1_, lvt_21_1_, lvt_22_1_, 1.0f).endVertex();
            }
            lvt_18_1_.draw();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5888);
            this.bindTexture(END_SKY_TEXTURE);
        }
        GlStateManager.disableBlend();
        GlStateManager.disableTexGenCoord(GlStateManager.TexGen.S);
        GlStateManager.disableTexGenCoord(GlStateManager.TexGen.T);
        GlStateManager.disableTexGenCoord(GlStateManager.TexGen.R);
        GlStateManager.enableLighting();
        if (lvt_14_1_) {
            Minecraft.getMinecraft().entityRenderer.func_191514_d(false);
        }
    }

    protected int getPasses(double p_getPasses_1_) {
        int lvt_3_9_;
        if (p_getPasses_1_ > 36864.0) {
            boolean lvt_3_1_ = true;
        } else if (p_getPasses_1_ > 25600.0) {
            int lvt_3_2_ = 3;
        } else if (p_getPasses_1_ > 16384.0) {
            int lvt_3_3_ = 5;
        } else if (p_getPasses_1_ > 9216.0) {
            int lvt_3_4_ = 7;
        } else if (p_getPasses_1_ > 4096.0) {
            int lvt_3_5_ = 9;
        } else if (p_getPasses_1_ > 1024.0) {
            int lvt_3_6_ = 11;
        } else if (p_getPasses_1_ > 576.0) {
            int lvt_3_7_ = 13;
        } else if (p_getPasses_1_ > 256.0) {
            int lvt_3_8_ = 14;
        } else {
            lvt_3_9_ = 15;
        }
        return lvt_3_9_;
    }

    protected float getOffset() {
        return 0.75f;
    }

    private FloatBuffer getBuffer(float p_getBuffer_1_, float p_getBuffer_2_, float p_getBuffer_3_, float p_getBuffer_4_) {
        this.buffer.clear();
        this.buffer.put(p_getBuffer_1_).put(p_getBuffer_2_).put(p_getBuffer_3_).put(p_getBuffer_4_);
        this.buffer.flip();
        return this.buffer;
    }
}

