/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityPistonRenderer
extends TileEntitySpecialRenderer<TileEntityPiston> {
    private BlockRendererDispatcher blockRenderer;

    @Override
    public void renderTileEntityAt(TileEntityPiston p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_, int p_renderTileEntityAt_9_) {
        if (this.blockRenderer == null) {
            this.blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        }
        BlockPos blockpos = p_renderTileEntityAt_1_.getPos();
        IBlockState iblockstate = p_renderTileEntityAt_1_.getPistonState();
        Block block = iblockstate.getBlock();
        if (iblockstate.getMaterial() != Material.AIR && p_renderTileEntityAt_1_.getProgress(p_renderTileEntityAt_8_) < 1.0f) {
            Tessellator tessellator = Tessellator.getInstance();
            VertexBuffer vertexbuffer = tessellator.getBuffer();
            this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            RenderHelper.disableStandardItemLighting();
            GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.enableBlend();
            GlStateManager.disableCull();
            if (Minecraft.isAmbientOcclusionEnabled()) {
                GlStateManager.shadeModel(7425);
            } else {
                GlStateManager.shadeModel(7424);
            }
            vertexbuffer.begin(7, DefaultVertexFormats.BLOCK);
            vertexbuffer.setTranslation(p_renderTileEntityAt_2_ - (double)blockpos.getX() + (double)p_renderTileEntityAt_1_.getOffsetX(p_renderTileEntityAt_8_), p_renderTileEntityAt_4_ - (double)blockpos.getY() + (double)p_renderTileEntityAt_1_.getOffsetY(p_renderTileEntityAt_8_), p_renderTileEntityAt_6_ - (double)blockpos.getZ() + (double)p_renderTileEntityAt_1_.getOffsetZ(p_renderTileEntityAt_8_));
            World world = this.getWorld();
            if (block == Blocks.PISTON_HEAD && p_renderTileEntityAt_1_.getProgress(p_renderTileEntityAt_8_) <= 0.25f) {
                iblockstate = iblockstate.withProperty(BlockPistonExtension.SHORT, true);
                this.renderStateModel(blockpos, iblockstate, vertexbuffer, world, true);
            } else if (p_renderTileEntityAt_1_.shouldPistonHeadBeRendered() && !p_renderTileEntityAt_1_.isExtending()) {
                BlockPistonExtension.EnumPistonType blockpistonextension$enumpistontype = block == Blocks.STICKY_PISTON ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT;
                IBlockState iblockstate1 = Blocks.PISTON_HEAD.getDefaultState().withProperty(BlockPistonExtension.TYPE, blockpistonextension$enumpistontype).withProperty(BlockPistonExtension.FACING, iblockstate.getValue(BlockPistonBase.FACING));
                iblockstate1 = iblockstate1.withProperty(BlockPistonExtension.SHORT, p_renderTileEntityAt_1_.getProgress(p_renderTileEntityAt_8_) >= 0.5f);
                this.renderStateModel(blockpos, iblockstate1, vertexbuffer, world, true);
                vertexbuffer.setTranslation(p_renderTileEntityAt_2_ - (double)blockpos.getX(), p_renderTileEntityAt_4_ - (double)blockpos.getY(), p_renderTileEntityAt_6_ - (double)blockpos.getZ());
                iblockstate = iblockstate.withProperty(BlockPistonBase.EXTENDED, true);
                this.renderStateModel(blockpos, iblockstate, vertexbuffer, world, true);
            } else {
                this.renderStateModel(blockpos, iblockstate, vertexbuffer, world, false);
            }
            vertexbuffer.setTranslation(0.0, 0.0, 0.0);
            tessellator.draw();
            RenderHelper.enableStandardItemLighting();
        }
    }

    private boolean renderStateModel(BlockPos p_renderStateModel_1_, IBlockState p_renderStateModel_2_, VertexBuffer p_renderStateModel_3_, World p_renderStateModel_4_, boolean p_renderStateModel_5_) {
        return this.blockRenderer.getBlockModelRenderer().renderModel(p_renderStateModel_4_, this.blockRenderer.getModelForState(p_renderStateModel_2_), p_renderStateModel_2_, p_renderStateModel_1_, p_renderStateModel_3_, p_renderStateModel_5_);
    }
}

