/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelShulker;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityBannerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityChestRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityEnchantmentTableRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityEndGatewayRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityEndPortalRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityEnderChestRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityMobSpawnerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityPistonRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityShulkerBoxRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySignRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityStructureRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererDispatcher {
    public final Map<Class<? extends TileEntity>, TileEntitySpecialRenderer<? extends TileEntity>> mapSpecialRenderers = Maps.newHashMap();
    public static TileEntityRendererDispatcher instance = new TileEntityRendererDispatcher();
    private FontRenderer fontRenderer;
    public static double staticPlayerX;
    public static double staticPlayerY;
    public static double staticPlayerZ;
    public TextureManager renderEngine;
    public World world;
    public Entity entity;
    public float entityYaw;
    public float entityPitch;
    public RayTraceResult cameraHitResult;
    public double entityX;
    public double entityY;
    public double entityZ;
    private Tessellator batchBuffer = new Tessellator(0x200000);
    private boolean drawingBatch = false;

    private TileEntityRendererDispatcher() {
        this.mapSpecialRenderers.put(TileEntitySign.class, new TileEntitySignRenderer());
        this.mapSpecialRenderers.put(TileEntityMobSpawner.class, new TileEntityMobSpawnerRenderer());
        this.mapSpecialRenderers.put(TileEntityPiston.class, new TileEntityPistonRenderer());
        this.mapSpecialRenderers.put(TileEntityChest.class, new TileEntityChestRenderer());
        this.mapSpecialRenderers.put(TileEntityEnderChest.class, new TileEntityEnderChestRenderer());
        this.mapSpecialRenderers.put(TileEntityEnchantmentTable.class, new TileEntityEnchantmentTableRenderer());
        this.mapSpecialRenderers.put(TileEntityEndPortal.class, new TileEntityEndPortalRenderer());
        this.mapSpecialRenderers.put(TileEntityEndGateway.class, new TileEntityEndGatewayRenderer());
        this.mapSpecialRenderers.put(TileEntityBeacon.class, new TileEntityBeaconRenderer());
        this.mapSpecialRenderers.put(TileEntitySkull.class, new TileEntitySkullRenderer());
        this.mapSpecialRenderers.put(TileEntityBanner.class, new TileEntityBannerRenderer());
        this.mapSpecialRenderers.put(TileEntityStructure.class, new TileEntityStructureRenderer());
        this.mapSpecialRenderers.put(TileEntityShulkerBox.class, new TileEntityShulkerBoxRenderer(new ModelShulker()));
        for (TileEntitySpecialRenderer<? extends TileEntity> tileentityspecialrenderer : this.mapSpecialRenderers.values()) {
            tileentityspecialrenderer.setRendererDispatcher(this);
        }
    }

    public <T extends TileEntity> TileEntitySpecialRenderer<T> getSpecialRendererByClass(Class<? extends TileEntity> p_getSpecialRendererByClass_1_) {
        TileEntitySpecialRenderer<TileEntity> tileentityspecialrenderer = this.mapSpecialRenderers.get(p_getSpecialRendererByClass_1_);
        if (tileentityspecialrenderer == null && p_getSpecialRendererByClass_1_ != TileEntity.class) {
            tileentityspecialrenderer = this.getSpecialRendererByClass(p_getSpecialRendererByClass_1_.getSuperclass());
            this.mapSpecialRenderers.put(p_getSpecialRendererByClass_1_, tileentityspecialrenderer);
        }
        return tileentityspecialrenderer;
    }

    @Nullable
    public <T extends TileEntity> TileEntitySpecialRenderer<T> getSpecialRenderer(TileEntity p_getSpecialRenderer_1_) {
        return p_getSpecialRenderer_1_ == null ? null : this.getSpecialRendererByClass(p_getSpecialRenderer_1_.getClass());
    }

    public void prepare(World p_prepare_1_, TextureManager p_prepare_2_, FontRenderer p_prepare_3_, Entity p_prepare_4_, RayTraceResult p_prepare_5_, float p_prepare_6_) {
        if (this.world != p_prepare_1_) {
            this.setWorld(p_prepare_1_);
        }
        this.renderEngine = p_prepare_2_;
        this.entity = p_prepare_4_;
        this.fontRenderer = p_prepare_3_;
        this.cameraHitResult = p_prepare_5_;
        this.entityYaw = p_prepare_4_.prevRotationYaw + (p_prepare_4_.rotationYaw - p_prepare_4_.prevRotationYaw) * p_prepare_6_;
        this.entityPitch = p_prepare_4_.prevRotationPitch + (p_prepare_4_.rotationPitch - p_prepare_4_.prevRotationPitch) * p_prepare_6_;
        this.entityX = p_prepare_4_.lastTickPosX + (p_prepare_4_.posX - p_prepare_4_.lastTickPosX) * (double)p_prepare_6_;
        this.entityY = p_prepare_4_.lastTickPosY + (p_prepare_4_.posY - p_prepare_4_.lastTickPosY) * (double)p_prepare_6_;
        this.entityZ = p_prepare_4_.lastTickPosZ + (p_prepare_4_.posZ - p_prepare_4_.lastTickPosZ) * (double)p_prepare_6_;
    }

    public void renderTileEntity(TileEntity p_renderTileEntity_1_, float p_renderTileEntity_2_, int p_renderTileEntity_3_) {
        if (p_renderTileEntity_1_.getDistanceSq(this.entityX, this.entityY, this.entityZ) < p_renderTileEntity_1_.getMaxRenderDistanceSquared()) {
            RenderHelper.enableStandardItemLighting();
            if (!this.drawingBatch || !p_renderTileEntity_1_.hasFastRenderer()) {
                int i = this.world.getCombinedLight(p_renderTileEntity_1_.getPos(), 0);
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, j, k);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            BlockPos blockpos = p_renderTileEntity_1_.getPos();
            this.renderTileEntityAt(p_renderTileEntity_1_, (double)blockpos.getX() - staticPlayerX, (double)blockpos.getY() - staticPlayerY, (double)blockpos.getZ() - staticPlayerZ, p_renderTileEntity_2_, p_renderTileEntity_3_);
        }
    }

    public void renderTileEntityAt(TileEntity p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_) {
        this.renderTileEntityAt(p_renderTileEntityAt_1_, p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_, p_renderTileEntityAt_8_, -1);
    }

    public void renderTileEntityAt(TileEntity p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_, int p_renderTileEntityAt_9_) {
        TileEntitySpecialRenderer<TileEntity> tileentityspecialrenderer = this.getSpecialRenderer(p_renderTileEntityAt_1_);
        if (tileentityspecialrenderer != null) {
            try {
                if (this.drawingBatch && p_renderTileEntityAt_1_.hasFastRenderer()) {
                    tileentityspecialrenderer.renderTileEntityFast(p_renderTileEntityAt_1_, p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_, p_renderTileEntityAt_8_, p_renderTileEntityAt_9_, this.batchBuffer.getBuffer());
                } else {
                    tileentityspecialrenderer.renderTileEntityAt(p_renderTileEntityAt_1_, p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_, p_renderTileEntityAt_8_, p_renderTileEntityAt_9_);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Rendering Block Entity");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Block Entity Details");
                p_renderTileEntityAt_1_.addInfoToCrashReport(crashreportcategory);
                throw new ReportedException(crashreport);
            }
        }
    }

    public void setWorld(World p_setWorld_1_) {
        this.world = p_setWorld_1_;
        if (p_setWorld_1_ == null) {
            this.entity = null;
        }
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public void preDrawBatch() {
        this.batchBuffer.getBuffer().begin(7, DefaultVertexFormats.BLOCK);
        this.drawingBatch = true;
    }

    public void drawBatch(int p_drawBatch_1_) {
        this.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc(770, 771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel(7425);
        } else {
            GlStateManager.shadeModel(7424);
        }
        if (p_drawBatch_1_ > 0) {
            this.batchBuffer.getBuffer().sortVertexData((float)staticPlayerX, (float)staticPlayerY, (float)staticPlayerZ);
        }
        this.batchBuffer.draw();
        RenderHelper.enableStandardItemLighting();
        this.drawingBatch = false;
    }
}

