/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.model.ModelSign;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntitySignRenderer
extends TileEntitySpecialRenderer<TileEntitySign> {
    private static final ResourceLocation SIGN_TEXTURE = new ResourceLocation("textures/entity/sign.png");
    private final ModelSign model = new ModelSign();

    @Override
    public void renderTileEntityAt(TileEntitySign p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_, int p_renderTileEntityAt_9_) {
        Block lvt_10_1_ = p_renderTileEntityAt_1_.getBlockType();
        GlStateManager.pushMatrix();
        float lvt_11_1_ = 0.6666667f;
        if (lvt_10_1_ == Blocks.STANDING_SIGN) {
            GlStateManager.translate((float)p_renderTileEntityAt_2_ + 0.5f, (float)p_renderTileEntityAt_4_ + 0.5f, (float)p_renderTileEntityAt_6_ + 0.5f);
            float lvt_12_1_ = (float)(p_renderTileEntityAt_1_.getBlockMetadata() * 360) / 16.0f;
            GlStateManager.rotate(-lvt_12_1_, 0.0f, 1.0f, 0.0f);
            this.model.signStick.showModel = true;
        } else {
            int lvt_12_2_ = p_renderTileEntityAt_1_.getBlockMetadata();
            float lvt_13_1_ = 0.0f;
            if (lvt_12_2_ == 2) {
                lvt_13_1_ = 180.0f;
            }
            if (lvt_12_2_ == 4) {
                lvt_13_1_ = 90.0f;
            }
            if (lvt_12_2_ == 5) {
                lvt_13_1_ = -90.0f;
            }
            GlStateManager.translate((float)p_renderTileEntityAt_2_ + 0.5f, (float)p_renderTileEntityAt_4_ + 0.5f, (float)p_renderTileEntityAt_6_ + 0.5f);
            GlStateManager.rotate(-lvt_13_1_, 0.0f, 1.0f, 0.0f);
            GlStateManager.translate(0.0f, -0.3125f, -0.4375f);
            this.model.signStick.showModel = false;
        }
        if (p_renderTileEntityAt_9_ >= 0) {
            this.bindTexture(DESTROY_STAGES[p_renderTileEntityAt_9_]);
            GlStateManager.matrixMode(5890);
            GlStateManager.pushMatrix();
            GlStateManager.scale(4.0f, 2.0f, 1.0f);
            GlStateManager.translate(0.0625f, 0.0625f, 0.0625f);
            GlStateManager.matrixMode(5888);
        } else {
            this.bindTexture(SIGN_TEXTURE);
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        GlStateManager.scale(0.6666667f, -0.6666667f, -0.6666667f);
        this.model.renderSign();
        GlStateManager.popMatrix();
        FontRenderer lvt_12_3_ = this.getFontRenderer();
        float lvt_13_2_ = 0.010416667f;
        GlStateManager.translate(0.0f, 0.33333334f, 0.046666667f);
        GlStateManager.scale(0.010416667f, -0.010416667f, 0.010416667f);
        GlStateManager.glNormal3f(0.0f, 0.0f, -0.010416667f);
        GlStateManager.depthMask(false);
        boolean lvt_14_1_ = false;
        if (p_renderTileEntityAt_9_ < 0) {
            for (int lvt_15_1_ = 0; lvt_15_1_ < p_renderTileEntityAt_1_.signText.length; ++lvt_15_1_) {
                String lvt_18_1_;
                if (p_renderTileEntityAt_1_.signText[lvt_15_1_] == null) continue;
                ITextComponent lvt_16_1_ = p_renderTileEntityAt_1_.signText[lvt_15_1_];
                List<ITextComponent> lvt_17_1_ = GuiUtilRenderComponents.splitText(lvt_16_1_, 90, lvt_12_3_, false, true);
                String string = lvt_18_1_ = lvt_17_1_ != null && !lvt_17_1_.isEmpty() ? lvt_17_1_.get(0).getFormattedText() : "";
                if (lvt_15_1_ == p_renderTileEntityAt_1_.lineBeingEdited) {
                    lvt_18_1_ = "> " + lvt_18_1_ + " <";
                    lvt_12_3_.drawString(lvt_18_1_, -lvt_12_3_.getStringWidth(lvt_18_1_) / 2, lvt_15_1_ * 10 - p_renderTileEntityAt_1_.signText.length * 5, 0);
                    continue;
                }
                lvt_12_3_.drawString(lvt_18_1_, -lvt_12_3_.getStringWidth(lvt_18_1_) / 2, lvt_15_1_ * 10 - p_renderTileEntityAt_1_.signText.length * 5, 0);
            }
        }
        GlStateManager.depthMask(true);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.popMatrix();
        if (p_renderTileEntityAt_9_ >= 0) {
            GlStateManager.matrixMode(5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5888);
        }
    }
}

