/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class TileEntitySpecialRenderer<T extends TileEntity> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/blocks/destroy_stage_0.png"), new ResourceLocation("textures/blocks/destroy_stage_1.png"), new ResourceLocation("textures/blocks/destroy_stage_2.png"), new ResourceLocation("textures/blocks/destroy_stage_3.png"), new ResourceLocation("textures/blocks/destroy_stage_4.png"), new ResourceLocation("textures/blocks/destroy_stage_5.png"), new ResourceLocation("textures/blocks/destroy_stage_6.png"), new ResourceLocation("textures/blocks/destroy_stage_7.png"), new ResourceLocation("textures/blocks/destroy_stage_8.png"), new ResourceLocation("textures/blocks/destroy_stage_9.png")};
    protected TileEntityRendererDispatcher rendererDispatcher;

    public void renderTileEntityAt(T p_renderTileEntityAt_1_, double p_renderTileEntityAt_2_, double p_renderTileEntityAt_4_, double p_renderTileEntityAt_6_, float p_renderTileEntityAt_8_, int p_renderTileEntityAt_9_) {
        ITextComponent itextcomponent = ((TileEntity)p_renderTileEntityAt_1_).getDisplayName();
        if (itextcomponent != null && this.rendererDispatcher.cameraHitResult != null && ((TileEntity)p_renderTileEntityAt_1_).getPos().equals(this.rendererDispatcher.cameraHitResult.getBlockPos())) {
            this.setLightmapDisabled(true);
            this.drawNameplate(p_renderTileEntityAt_1_, itextcomponent.getFormattedText(), p_renderTileEntityAt_2_, p_renderTileEntityAt_4_, p_renderTileEntityAt_6_, 12);
            this.setLightmapDisabled(false);
        }
    }

    protected void setLightmapDisabled(boolean p_setLightmapDisabled_1_) {
        GlStateManager.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        if (p_setLightmapDisabled_1_) {
            GlStateManager.disableTexture2D();
        } else {
            GlStateManager.enableTexture2D();
        }
        GlStateManager.setActiveTexture(OpenGlHelper.defaultTexUnit);
    }

    protected void bindTexture(ResourceLocation p_bindTexture_1_) {
        TextureManager texturemanager = this.rendererDispatcher.renderEngine;
        if (texturemanager != null) {
            texturemanager.bindTexture(p_bindTexture_1_);
        }
    }

    protected World getWorld() {
        return this.rendererDispatcher.world;
    }

    public void setRendererDispatcher(TileEntityRendererDispatcher p_setRendererDispatcher_1_) {
        this.rendererDispatcher = p_setRendererDispatcher_1_;
    }

    public FontRenderer getFontRenderer() {
        return this.rendererDispatcher.getFontRenderer();
    }

    public boolean isGlobalRenderer(T p_isGlobalRenderer_1_) {
        return false;
    }

    public void renderTileEntityFast(T p_renderTileEntityFast_1_, double p_renderTileEntityFast_2_, double p_renderTileEntityFast_4_, double p_renderTileEntityFast_6_, float p_renderTileEntityFast_8_, int p_renderTileEntityFast_9_, VertexBuffer p_renderTileEntityFast_10_) {
    }

    protected void drawNameplate(T p_drawNameplate_1_, String p_drawNameplate_2_, double p_drawNameplate_3_, double p_drawNameplate_5_, double p_drawNameplate_7_, int p_drawNameplate_9_) {
        Entity entity = this.rendererDispatcher.entity;
        double d0 = ((TileEntity)p_drawNameplate_1_).getDistanceSq(entity.posX, entity.posY, entity.posZ);
        if (d0 <= (double)(p_drawNameplate_9_ * p_drawNameplate_9_)) {
            float f = this.rendererDispatcher.entityYaw;
            float f1 = this.rendererDispatcher.entityPitch;
            boolean flag = false;
            EntityRenderer.drawNameplate(this.getFontRenderer(), p_drawNameplate_2_, (float)p_drawNameplate_3_ + 0.5f, (float)p_drawNameplate_5_ + 1.5f, (float)p_drawNameplate_7_ + 0.5f, 0, f, f1, false, false);
        }
    }
}

