/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractResourcePack
implements IResourcePack {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final File resourcePackFile;

    public AbstractResourcePack(File p_i1287_1_) {
        this.resourcePackFile = p_i1287_1_;
    }

    private static String locationToName(ResourceLocation p_locationToName_0_) {
        return String.format("%s/%s/%s", "assets", p_locationToName_0_.getResourceDomain(), p_locationToName_0_.getResourcePath());
    }

    protected static String getRelativeName(File p_getRelativeName_0_, File p_getRelativeName_1_) {
        return p_getRelativeName_0_.toURI().relativize(p_getRelativeName_1_.toURI()).getPath();
    }

    @Override
    public InputStream getInputStream(ResourceLocation p_getInputStream_1_) throws IOException {
        return this.getInputStreamByName(AbstractResourcePack.locationToName(p_getInputStream_1_));
    }

    @Override
    public boolean resourceExists(ResourceLocation p_resourceExists_1_) {
        return this.hasResourceName(AbstractResourcePack.locationToName(p_resourceExists_1_));
    }

    protected abstract InputStream getInputStreamByName(String var1) throws IOException;

    protected abstract boolean hasResourceName(String var1);

    protected void logNameNotLowercase(String p_logNameNotLowercase_1_) {
        LOGGER.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", new Object[]{p_logNameNotLowercase_1_, this.resourcePackFile});
    }

    @Override
    public <T extends IMetadataSection> T getPackMetadata(MetadataSerializer p_getPackMetadata_1_, String p_getPackMetadata_2_) throws IOException {
        return AbstractResourcePack.readMetadata(p_getPackMetadata_1_, this.getInputStreamByName("pack.mcmeta"), p_getPackMetadata_2_);
    }

    static <T extends IMetadataSection> T readMetadata(MetadataSerializer p_readMetadata_0_, InputStream p_readMetadata_1_, String p_readMetadata_2_) {
        JsonObject lvt_3_1_ = null;
        BufferedReader lvt_4_1_ = null;
        try {
            lvt_4_1_ = new BufferedReader(new InputStreamReader(p_readMetadata_1_, Charsets.UTF_8));
            lvt_3_1_ = new JsonParser().parse((Reader)lvt_4_1_).getAsJsonObject();
        }
        catch (RuntimeException lvt_5_1_) {
            try {
                throw new JsonParseException((Throwable)lvt_5_1_);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lvt_4_1_);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)lvt_4_1_);
        return p_readMetadata_0_.parseMetadataSection(p_readMetadata_2_, lvt_3_1_);
    }

    @Override
    public BufferedImage getPackImage() throws IOException {
        return TextureUtil.readBufferedImage(this.getInputStreamByName("pack.png"));
    }

    @Override
    public String getPackName() {
        return this.resourcePackFile.getName();
    }
}

