/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DefaultResourcePack
implements IResourcePack {
    public static final Set<String> DEFAULT_RESOURCE_DOMAINS = ImmutableSet.of((Object)"minecraft", (Object)"realms");
    private final ResourceIndex resourceIndex;

    public DefaultResourcePack(ResourceIndex p_i46541_1_) {
        this.resourceIndex = p_i46541_1_;
    }

    @Override
    public InputStream getInputStream(ResourceLocation p_getInputStream_1_) throws IOException {
        InputStream lvt_2_1_ = this.getResourceStream(p_getInputStream_1_);
        if (lvt_2_1_ != null) {
            return lvt_2_1_;
        }
        InputStream lvt_3_1_ = this.getInputStreamAssets(p_getInputStream_1_);
        if (lvt_3_1_ != null) {
            return lvt_3_1_;
        }
        throw new FileNotFoundException(p_getInputStream_1_.getResourcePath());
    }

    @Nullable
    public InputStream getInputStreamAssets(ResourceLocation p_getInputStreamAssets_1_) throws IOException, FileNotFoundException {
        File lvt_2_1_ = this.resourceIndex.getFile(p_getInputStreamAssets_1_);
        return lvt_2_1_ == null || !lvt_2_1_.isFile() ? null : new FileInputStream(lvt_2_1_);
    }

    @Nullable
    private InputStream getResourceStream(ResourceLocation p_getResourceStream_1_) {
        String lvt_2_1_ = "/assets/" + p_getResourceStream_1_.getResourceDomain() + "/" + p_getResourceStream_1_.getResourcePath();
        try {
            URL lvt_3_1_ = DefaultResourcePack.class.getResource(lvt_2_1_);
            if (lvt_3_1_ != null && FolderResourcePack.validatePath(new File(lvt_3_1_.getFile()), lvt_2_1_)) {
                return DefaultResourcePack.class.getResourceAsStream(lvt_2_1_);
            }
        }
        catch (IOException lvt_3_2_) {
            return DefaultResourcePack.class.getResourceAsStream(lvt_2_1_);
        }
        return null;
    }

    @Override
    public boolean resourceExists(ResourceLocation p_resourceExists_1_) {
        return this.getResourceStream(p_resourceExists_1_) != null || this.resourceIndex.isFileExisting(p_resourceExists_1_);
    }

    @Override
    public Set<String> getResourceDomains() {
        return DEFAULT_RESOURCE_DOMAINS;
    }

    @Override
    @Nullable
    public <T extends IMetadataSection> T getPackMetadata(MetadataSerializer p_getPackMetadata_1_, String p_getPackMetadata_2_) throws IOException {
        try {
            FileInputStream lvt_3_1_ = new FileInputStream(this.resourceIndex.getPackMcmeta());
            return AbstractResourcePack.readMetadata(p_getPackMetadata_1_, lvt_3_1_, p_getPackMetadata_2_);
        }
        catch (RuntimeException lvt_3_2_) {
            return null;
        }
        catch (FileNotFoundException lvt_3_3_) {
            return null;
        }
    }

    @Override
    public BufferedImage getPackImage() throws IOException {
        return TextureUtil.readBufferedImage(DefaultResourcePack.class.getResourceAsStream("/" + new ResourceLocation("pack.png").getResourcePath()));
    }

    @Override
    public String getPackName() {
        return "Default";
    }
}

