/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleResource;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class FallbackResourceManager
implements IResourceManager {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final List<IResourcePack> resourcePacks = Lists.newArrayList();
    private final MetadataSerializer frmMetadataSerializer;

    public FallbackResourceManager(MetadataSerializer p_i1289_1_) {
        this.frmMetadataSerializer = p_i1289_1_;
    }

    public void addResourcePack(IResourcePack p_addResourcePack_1_) {
        this.resourcePacks.add(p_addResourcePack_1_);
    }

    @Override
    public Set<String> getResourceDomains() {
        return Collections.emptySet();
    }

    @Override
    public IResource getResource(ResourceLocation p_getResource_1_) throws IOException {
        this.checkResourcePath(p_getResource_1_);
        IResourcePack iresourcepack = null;
        ResourceLocation resourcelocation = FallbackResourceManager.getLocationMcmeta(p_getResource_1_);
        for (int i = this.resourcePacks.size() - 1; i >= 0; --i) {
            IResourcePack iresourcepack1 = this.resourcePacks.get(i);
            if (iresourcepack == null && iresourcepack1.resourceExists(resourcelocation)) {
                iresourcepack = iresourcepack1;
            }
            if (!iresourcepack1.resourceExists(p_getResource_1_)) continue;
            InputStream inputstream = null;
            if (iresourcepack != null) {
                inputstream = this.getInputStream(resourcelocation, iresourcepack);
            }
            return new SimpleResource(iresourcepack1.getPackName(), p_getResource_1_, this.getInputStream(p_getResource_1_, iresourcepack1), inputstream, this.frmMetadataSerializer);
        }
        throw new FileNotFoundException(p_getResource_1_.toString());
    }

    protected InputStream getInputStream(ResourceLocation p_getInputStream_1_, IResourcePack p_getInputStream_2_) throws IOException {
        InputStream inputstream = p_getInputStream_2_.getInputStream(p_getInputStream_1_);
        return LOGGER.isDebugEnabled() ? new InputStreamLeakedResourceLogger(inputstream, p_getInputStream_1_, p_getInputStream_2_.getPackName()) : inputstream;
    }

    private void checkResourcePath(ResourceLocation p_checkResourcePath_1_) throws IOException {
        if (p_checkResourcePath_1_.getResourcePath().contains("..")) {
            throw new IOException("Invalid relative path to resource: " + p_checkResourcePath_1_);
        }
    }

    @Override
    public List<IResource> getAllResources(ResourceLocation p_getAllResources_1_) throws IOException {
        this.checkResourcePath(p_getAllResources_1_);
        ArrayList list = Lists.newArrayList();
        ResourceLocation resourcelocation = FallbackResourceManager.getLocationMcmeta(p_getAllResources_1_);
        for (IResourcePack iresourcepack : this.resourcePacks) {
            if (!iresourcepack.resourceExists(p_getAllResources_1_)) continue;
            InputStream inputstream = iresourcepack.resourceExists(resourcelocation) ? this.getInputStream(resourcelocation, iresourcepack) : null;
            list.add(new SimpleResource(iresourcepack.getPackName(), p_getAllResources_1_, this.getInputStream(p_getAllResources_1_, iresourcepack), inputstream, this.frmMetadataSerializer));
        }
        if (list.isEmpty()) {
            throw new FileNotFoundException(p_getAllResources_1_.toString());
        }
        return list;
    }

    static ResourceLocation getLocationMcmeta(ResourceLocation p_getLocationMcmeta_0_) {
        return new ResourceLocation(p_getLocationMcmeta_0_.getResourceDomain(), p_getLocationMcmeta_0_.getResourcePath() + ".mcmeta");
    }

    @SideOnly(value=Side.CLIENT)
    static class InputStreamLeakedResourceLogger
    extends InputStream {
        private final InputStream inputStream;
        private final String message;
        private boolean isClosed;

        public InputStreamLeakedResourceLogger(InputStream p_i46093_1_, ResourceLocation p_i46093_2_, String p_i46093_3_) {
            this.inputStream = p_i46093_1_;
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(bytearrayoutputstream));
            this.message = "Leaked resource: '" + p_i46093_2_ + "' loaded from pack: '" + p_i46093_3_ + "'\n" + bytearrayoutputstream;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
            this.isClosed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.isClosed) {
                LOGGER.warn(this.message);
            }
            super.finalize();
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }
    }
}

