/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FileResourcePack
extends AbstractResourcePack
implements Closeable {
    public static final Splitter ENTRY_NAME_SPLITTER = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    private ZipFile resourcePackZipFile;

    public FileResourcePack(File p_i1290_1_) {
        super(p_i1290_1_);
    }

    private ZipFile getResourcePackZipFile() throws IOException {
        if (this.resourcePackZipFile == null) {
            this.resourcePackZipFile = new ZipFile(this.resourcePackFile);
        }
        return this.resourcePackZipFile;
    }

    @Override
    protected InputStream getInputStreamByName(String p_getInputStreamByName_1_) throws IOException {
        ZipFile lvt_2_1_ = this.getResourcePackZipFile();
        ZipEntry lvt_3_1_ = lvt_2_1_.getEntry(p_getInputStreamByName_1_);
        if (lvt_3_1_ == null) {
            throw new ResourcePackFileNotFoundException(this.resourcePackFile, p_getInputStreamByName_1_);
        }
        return lvt_2_1_.getInputStream(lvt_3_1_);
    }

    @Override
    public boolean hasResourceName(String p_hasResourceName_1_) {
        try {
            return this.getResourcePackZipFile().getEntry(p_hasResourceName_1_) != null;
        }
        catch (IOException lvt_2_1_) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> getResourceDomains() {
        void lvt_1_2_;
        try {
            ZipFile lvt_1_1_ = this.getResourcePackZipFile();
        }
        catch (IOException lvt_2_1_) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> lvt_2_2_ = lvt_1_2_.entries();
        HashSet lvt_3_1_ = Sets.newHashSet();
        while (lvt_2_2_.hasMoreElements()) {
            ArrayList lvt_6_1_;
            ZipEntry lvt_4_1_ = lvt_2_2_.nextElement();
            String lvt_5_1_ = lvt_4_1_.getName();
            if (!lvt_5_1_.startsWith("assets/") || (lvt_6_1_ = Lists.newArrayList((Iterable)ENTRY_NAME_SPLITTER.split((CharSequence)lvt_5_1_))).size() <= 1) continue;
            String lvt_7_1_ = (String)lvt_6_1_.get(1);
            if (lvt_7_1_.equals(lvt_7_1_.toLowerCase(Locale.ROOT))) {
                lvt_3_1_.add(lvt_7_1_);
                continue;
            }
            this.logNameNotLowercase(lvt_7_1_);
        }
        return lvt_3_1_;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        if (this.resourcePackZipFile != null) {
            this.resourcePackZipFile.close();
            this.resourcePackZipFile = null;
        }
    }
}

