/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;
import net.minecraft.util.Util;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

@SideOnly(value=Side.CLIENT)
public class FolderResourcePack
extends AbstractResourcePack {
    private static final boolean ON_WINDOWS = Util.getOSType() == Util.EnumOS.WINDOWS;
    private static final CharMatcher BACKSLASH_MATCHER = CharMatcher.is((char)'\\');

    public FolderResourcePack(File p_i1291_1_) {
        super(p_i1291_1_);
    }

    protected static boolean validatePath(File p_validatePath_0_, String p_validatePath_1_) throws IOException {
        String lvt_2_1_ = p_validatePath_0_.getCanonicalPath();
        if (ON_WINDOWS) {
            lvt_2_1_ = BACKSLASH_MATCHER.replaceFrom((CharSequence)lvt_2_1_, '/');
        }
        return lvt_2_1_.endsWith(p_validatePath_1_);
    }

    @Override
    protected InputStream getInputStreamByName(String p_getInputStreamByName_1_) throws IOException {
        File lvt_2_1_ = this.getFile(p_getInputStreamByName_1_);
        if (lvt_2_1_ == null) {
            throw new ResourcePackFileNotFoundException(this.resourcePackFile, p_getInputStreamByName_1_);
        }
        return new BufferedInputStream(new FileInputStream(lvt_2_1_));
    }

    @Override
    protected boolean hasResourceName(String p_hasResourceName_1_) {
        return this.getFile(p_hasResourceName_1_) != null;
    }

    @Nullable
    private File getFile(String p_getFile_1_) {
        try {
            File lvt_2_1_ = new File(this.resourcePackFile, p_getFile_1_);
            if (lvt_2_1_.isFile() && FolderResourcePack.validatePath(lvt_2_1_, p_getFile_1_)) {
                return lvt_2_1_;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Set<String> getResourceDomains() {
        HashSet lvt_1_1_ = Sets.newHashSet();
        File lvt_2_1_ = new File(this.resourcePackFile, "assets/");
        if (lvt_2_1_.isDirectory()) {
            for (File lvt_6_1_ : lvt_2_1_.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
                String lvt_7_1_ = FolderResourcePack.getRelativeName(lvt_2_1_, lvt_6_1_);
                if (lvt_7_1_.equals(lvt_7_1_.toLowerCase(Locale.ROOT))) {
                    lvt_1_1_.add(lvt_7_1_.substring(0, lvt_7_1_.length() - 1));
                    continue;
                }
                this.logNameNotLowercase(lvt_7_1_);
            }
        }
        return lvt_1_1_;
    }
}

