/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.Locale;
import net.minecraft.client.resources.data.LanguageMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class LanguageManager
implements IResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MetadataSerializer theMetadataSerializer;
    private String currentLanguage;
    protected static final Locale CURRENT_LOCALE = new Locale();
    private final Map<String, Language> languageMap = Maps.newHashMap();

    public LanguageManager(MetadataSerializer p_i1304_1_, String p_i1304_2_) {
        this.theMetadataSerializer = p_i1304_1_;
        this.currentLanguage = p_i1304_2_;
        I18n.setLocale(CURRENT_LOCALE);
    }

    public void parseLanguageMetadata(List<IResourcePack> p_parseLanguageMetadata_1_) {
        this.languageMap.clear();
        for (IResourcePack lvt_3_1_ : p_parseLanguageMetadata_1_) {
            try {
                LanguageMetadataSection lvt_4_1_ = (LanguageMetadataSection)lvt_3_1_.getPackMetadata(this.theMetadataSerializer, "language");
                if (lvt_4_1_ == null) continue;
                for (Language lvt_6_1_ : lvt_4_1_.getLanguages()) {
                    if (this.languageMap.containsKey(lvt_6_1_.getLanguageCode())) continue;
                    this.languageMap.put(lvt_6_1_.getLanguageCode(), lvt_6_1_);
                }
            }
            catch (RuntimeException lvt_4_2_) {
                LOGGER.warn("Unable to parse language metadata section of resourcepack: {}", new Object[]{lvt_3_1_.getPackName(), lvt_4_2_});
            }
            catch (IOException lvt_4_3_) {
                LOGGER.warn("Unable to parse language metadata section of resourcepack: {}", new Object[]{lvt_3_1_.getPackName(), lvt_4_3_});
            }
        }
    }

    @Override
    public void onResourceManagerReload(IResourceManager p_onResourceManagerReload_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList((Object[])new String[]{"en_us"});
        if (!"en_us".equals(this.currentLanguage)) {
            lvt_2_1_.add(this.currentLanguage);
        }
        CURRENT_LOCALE.loadLocaleDataFiles(p_onResourceManagerReload_1_, lvt_2_1_);
        LanguageMap.replaceWith(LanguageManager.CURRENT_LOCALE.properties);
    }

    public boolean isCurrentLocaleUnicode() {
        return CURRENT_LOCALE.isUnicode();
    }

    public boolean isCurrentLanguageBidirectional() {
        return this.getCurrentLanguage() != null && this.getCurrentLanguage().isBidirectional();
    }

    public void setCurrentLanguage(Language p_setCurrentLanguage_1_) {
        this.currentLanguage = p_setCurrentLanguage_1_.getLanguageCode();
    }

    public Language getCurrentLanguage() {
        String lvt_1_1_ = this.languageMap.containsKey(this.currentLanguage) ? this.currentLanguage : "en_us";
        return this.languageMap.get(lvt_1_1_);
    }

    public SortedSet<Language> getLanguages() {
        return Sets.newTreeSet(this.languageMap.values());
    }
}

