/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class Locale {
    private static final Splitter SPLITTER = Splitter.on((char)'=').limit(2);
    private static final Pattern PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    Map<String, String> properties = Maps.newHashMap();
    private boolean unicode;

    public synchronized void loadLocaleDataFiles(IResourceManager p_loadLocaleDataFiles_1_, List<String> p_loadLocaleDataFiles_2_) {
        this.properties.clear();
        for (String s : p_loadLocaleDataFiles_2_) {
            String s1 = String.format("lang/%s.lang", s);
            for (String s2 : p_loadLocaleDataFiles_1_.getResourceDomains()) {
                try {
                    this.loadLocaleData(p_loadLocaleDataFiles_1_.getAllResources(new ResourceLocation(s2, s1)));
                }
                catch (IOException iOException) {}
            }
        }
        this.checkUnicode();
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    private void checkUnicode() {
        this.unicode = false;
        int i = 0;
        int j = 0;
        for (String s : this.properties.values()) {
            int k = s.length();
            j += k;
            for (int l = 0; l < k; ++l) {
                if (s.charAt(l) < '\u0100') continue;
                ++i;
            }
        }
        float f = (float)i / (float)j;
        this.unicode = (double)f > 0.1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocaleData(List<IResource> p_loadLocaleData_1_) throws IOException {
        for (IResource iresource : p_loadLocaleData_1_) {
            InputStream inputstream = iresource.getInputStream();
            try {
                this.loadLocaleData(inputstream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputstream);
            }
        }
    }

    private void loadLocaleData(InputStream p_loadLocaleData_1_) throws IOException {
        p_loadLocaleData_1_ = FMLCommonHandler.instance().loadLanguage(this.properties, p_loadLocaleData_1_);
        if (p_loadLocaleData_1_ == null) {
            return;
        }
        for (String s : IOUtils.readLines((InputStream)p_loadLocaleData_1_, (Charset)Charsets.UTF_8)) {
            String[] astring;
            if (s.isEmpty() || s.charAt(0) == '#' || (astring = (String[])Iterables.toArray((Iterable)SPLITTER.split((CharSequence)s), String.class)) == null || astring.length != 2) continue;
            String s1 = astring[0];
            String s2 = PATTERN.matcher(astring[1]).replaceAll("%$1s");
            this.properties.put(s1, s2);
        }
    }

    private String translateKeyPrivate(String p_translateKeyPrivate_1_) {
        String s = this.properties.get(p_translateKeyPrivate_1_);
        return s == null ? p_translateKeyPrivate_1_ : s;
    }

    public String formatMessage(String p_formatMessage_1_, Object[] p_formatMessage_2_) {
        String s = this.translateKeyPrivate(p_formatMessage_1_);
        try {
            return String.format(s, p_formatMessage_2_);
        }
        catch (IllegalFormatException var5) {
            return "Format error: " + s;
        }
    }

    public boolean hasKey(String p_hasKey_1_) {
        return this.properties.containsKey(p_hasKey_1_);
    }
}

