/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ResourceIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, File> resourceMap = Maps.newHashMap();

    protected ResourceIndex() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceIndex(File p_i1047_1_, String p_i1047_2_) {
        File lvt_3_1_ = new File(p_i1047_1_, "objects");
        File lvt_4_1_ = new File(p_i1047_1_, "indexes/" + p_i1047_2_ + ".json");
        BufferedReader lvt_5_1_ = null;
        try {
            lvt_5_1_ = Files.newReader((File)lvt_4_1_, (Charset)Charsets.UTF_8);
            JsonObject lvt_6_1_ = new JsonParser().parse((Reader)lvt_5_1_).getAsJsonObject();
            JsonObject lvt_7_1_ = JsonUtils.getJsonObject(lvt_6_1_, "objects", null);
            if (lvt_7_1_ != null) {
                for (Map.Entry lvt_9_1_ : lvt_7_1_.entrySet()) {
                    JsonObject lvt_10_1_ = (JsonObject)lvt_9_1_.getValue();
                    String lvt_11_1_ = (String)lvt_9_1_.getKey();
                    String[] lvt_12_1_ = lvt_11_1_.split("/", 2);
                    String lvt_13_1_ = lvt_12_1_.length == 1 ? lvt_12_1_[0] : lvt_12_1_[0] + ":" + lvt_12_1_[1];
                    String lvt_14_1_ = JsonUtils.getString(lvt_10_1_, "hash");
                    File lvt_15_1_ = new File(lvt_3_1_, lvt_14_1_.substring(0, 2) + "/" + lvt_14_1_);
                    this.resourceMap.put(lvt_13_1_, lvt_15_1_);
                }
            }
        }
        catch (JsonParseException lvt_6_2_) {
            LOGGER.error("Unable to parse resource index file: {}", new Object[]{lvt_4_1_});
        }
        catch (FileNotFoundException lvt_6_3_) {
            LOGGER.error("Can't find the resource index file: {}", new Object[]{lvt_4_1_});
        }
        finally {
            IOUtils.closeQuietly((Reader)lvt_5_1_);
        }
    }

    @Nullable
    public File getFile(ResourceLocation p_getFile_1_) {
        String lvt_2_1_ = p_getFile_1_.toString();
        return this.resourceMap.get(lvt_2_1_);
    }

    public boolean isFileExisting(ResourceLocation p_isFileExisting_1_) {
        File lvt_2_1_ = this.getFile(p_isFileExisting_1_);
        return lvt_2_1_ != null && lvt_2_1_.isFile();
    }

    public File getPackMcmeta() {
        return this.resourceMap.get("pack.mcmeta");
    }
}

