/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class ResourcePackListEntry
implements GuiListExtended.IGuiListEntry {
    private static final ResourceLocation RESOURCE_PACKS_TEXTURE = new ResourceLocation("textures/gui/resource_packs.png");
    private static final ITextComponent INCOMPATIBLE = new TextComponentTranslation("resourcePack.incompatible", new Object[0]);
    private static final ITextComponent INCOMPATIBLE_OLD = new TextComponentTranslation("resourcePack.incompatible.old", new Object[0]);
    private static final ITextComponent INCOMPATIBLE_NEW = new TextComponentTranslation("resourcePack.incompatible.new", new Object[0]);
    protected final Minecraft mc;
    protected final GuiScreenResourcePacks resourcePacksGUI;

    public ResourcePackListEntry(GuiScreenResourcePacks p_i45051_1_) {
        this.resourcePacksGUI = p_i45051_1_;
        this.mc = Minecraft.getMinecraft();
    }

    @Override
    public void drawEntry(int p_drawEntry_1_, int p_drawEntry_2_, int p_drawEntry_3_, int p_drawEntry_4_, int p_drawEntry_5_, int p_drawEntry_6_, int p_drawEntry_7_, boolean p_drawEntry_8_) {
        int lvt_12_2_;
        int lvt_9_1_ = this.getResourcePackFormat();
        if (lvt_9_1_ != 3) {
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            Gui.drawRect(p_drawEntry_2_ - 1, p_drawEntry_3_ - 1, p_drawEntry_2_ + p_drawEntry_4_ - 9, p_drawEntry_3_ + p_drawEntry_5_ + 1, -8978432);
        }
        this.bindResourcePackIcon();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 0.0f, 0.0f, 32, 32, 32.0f, 32.0f);
        String lvt_10_1_ = this.getResourcePackName();
        String lvt_11_1_ = this.getResourcePackDescription();
        if (this.showHoverOverlay() && (this.mc.gameSettings.touchscreen || p_drawEntry_8_)) {
            this.mc.getTextureManager().bindTexture(RESOURCE_PACKS_TEXTURE);
            Gui.drawRect(p_drawEntry_2_, p_drawEntry_3_, p_drawEntry_2_ + 32, p_drawEntry_3_ + 32, -1601138544);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            int lvt_12_1_ = p_drawEntry_6_ - p_drawEntry_2_;
            int lvt_13_1_ = p_drawEntry_7_ - p_drawEntry_3_;
            if (lvt_9_1_ < 3) {
                lvt_10_1_ = INCOMPATIBLE.getFormattedText();
                lvt_11_1_ = INCOMPATIBLE_OLD.getFormattedText();
            } else if (lvt_9_1_ > 3) {
                lvt_10_1_ = INCOMPATIBLE.getFormattedText();
                lvt_11_1_ = INCOMPATIBLE_NEW.getFormattedText();
            }
            if (this.canMoveRight()) {
                if (lvt_12_1_ < 32) {
                    Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 0.0f, 32.0f, 32, 32, 256.0f, 256.0f);
                } else {
                    Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 0.0f, 0.0f, 32, 32, 256.0f, 256.0f);
                }
            } else {
                if (this.canMoveLeft()) {
                    if (lvt_12_1_ < 16) {
                        Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 32.0f, 32.0f, 32, 32, 256.0f, 256.0f);
                    } else {
                        Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 32.0f, 0.0f, 32, 32, 256.0f, 256.0f);
                    }
                }
                if (this.canMoveUp()) {
                    if (lvt_12_1_ < 32 && lvt_12_1_ > 16 && lvt_13_1_ < 16) {
                        Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 96.0f, 32.0f, 32, 32, 256.0f, 256.0f);
                    } else {
                        Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 96.0f, 0.0f, 32, 32, 256.0f, 256.0f);
                    }
                }
                if (this.canMoveDown()) {
                    if (lvt_12_1_ < 32 && lvt_12_1_ > 16 && lvt_13_1_ > 16) {
                        Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 64.0f, 32.0f, 32, 32, 256.0f, 256.0f);
                    } else {
                        Gui.drawModalRectWithCustomSizedTexture(p_drawEntry_2_, p_drawEntry_3_, 64.0f, 0.0f, 32, 32, 256.0f, 256.0f);
                    }
                }
            }
        }
        if ((lvt_12_2_ = this.mc.fontRendererObj.getStringWidth(lvt_10_1_)) > 157) {
            lvt_10_1_ = this.mc.fontRendererObj.trimStringToWidth(lvt_10_1_, 157 - this.mc.fontRendererObj.getStringWidth("...")) + "...";
        }
        this.mc.fontRendererObj.drawStringWithShadow(lvt_10_1_, p_drawEntry_2_ + 32 + 2, p_drawEntry_3_ + 1, 0xFFFFFF);
        List<String> lvt_13_2_ = this.mc.fontRendererObj.listFormattedStringToWidth(lvt_11_1_, 157);
        for (int lvt_14_1_ = 0; lvt_14_1_ < 2 && lvt_14_1_ < lvt_13_2_.size(); ++lvt_14_1_) {
            this.mc.fontRendererObj.drawStringWithShadow(lvt_13_2_.get(lvt_14_1_), p_drawEntry_2_ + 32 + 2, p_drawEntry_3_ + 12 + 10 * lvt_14_1_, 0x808080);
        }
    }

    protected abstract int getResourcePackFormat();

    protected abstract String getResourcePackDescription();

    protected abstract String getResourcePackName();

    protected abstract void bindResourcePackIcon();

    protected boolean showHoverOverlay() {
        return true;
    }

    protected boolean canMoveRight() {
        return !this.resourcePacksGUI.hasResourcePackEntry(this);
    }

    protected boolean canMoveLeft() {
        return this.resourcePacksGUI.hasResourcePackEntry(this);
    }

    protected boolean canMoveUp() {
        List<ResourcePackListEntry> lvt_1_1_ = this.resourcePacksGUI.getListContaining(this);
        int lvt_2_1_ = lvt_1_1_.indexOf(this);
        return lvt_2_1_ > 0 && lvt_1_1_.get(lvt_2_1_ - 1).showHoverOverlay();
    }

    protected boolean canMoveDown() {
        List<ResourcePackListEntry> lvt_1_1_ = this.resourcePacksGUI.getListContaining(this);
        int lvt_2_1_ = lvt_1_1_.indexOf(this);
        return lvt_2_1_ >= 0 && lvt_2_1_ < lvt_1_1_.size() - 1 && lvt_1_1_.get(lvt_2_1_ + 1).showHoverOverlay();
    }

    @Override
    public boolean mousePressed(int p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_, int p_mousePressed_4_, int p_mousePressed_5_, int p_mousePressed_6_) {
        if (this.showHoverOverlay() && p_mousePressed_5_ <= 32) {
            if (this.canMoveRight()) {
                this.resourcePacksGUI.markChanged();
                final int lvt_7_1_ = this.resourcePacksGUI.getSelectedResourcePacks().get(0).isServerPack() ? 1 : 0;
                int lvt_8_1_ = this.getResourcePackFormat();
                if (lvt_8_1_ == 3) {
                    this.resourcePacksGUI.getListContaining(this).remove(this);
                    this.resourcePacksGUI.getSelectedResourcePacks().add(lvt_7_1_, this);
                } else {
                    String lvt_9_1_ = I18n.format("resourcePack.incompatible.confirm.title", new Object[0]);
                    String lvt_10_1_ = I18n.format("resourcePack.incompatible.confirm." + (lvt_8_1_ > 3 ? "new" : "old"), new Object[0]);
                    this.mc.displayGuiScreen(new GuiYesNo(new GuiYesNoCallback(){

                        @Override
                        public void confirmClicked(boolean p_confirmClicked_1_, int p_confirmClicked_2_) {
                            List<ResourcePackListEntry> lvt_3_1_ = ResourcePackListEntry.this.resourcePacksGUI.getListContaining(ResourcePackListEntry.this);
                            ResourcePackListEntry.this.mc.displayGuiScreen(ResourcePackListEntry.this.resourcePacksGUI);
                            if (p_confirmClicked_1_) {
                                lvt_3_1_.remove(ResourcePackListEntry.this);
                                ResourcePackListEntry.this.resourcePacksGUI.getSelectedResourcePacks().add(lvt_7_1_, ResourcePackListEntry.this);
                            }
                        }
                    }, lvt_9_1_, lvt_10_1_, 0));
                }
                return true;
            }
            if (p_mousePressed_5_ < 16 && this.canMoveLeft()) {
                this.resourcePacksGUI.getListContaining(this).remove(this);
                this.resourcePacksGUI.getAvailableResourcePacks().add(0, this);
                this.resourcePacksGUI.markChanged();
                return true;
            }
            if (p_mousePressed_5_ > 16 && p_mousePressed_6_ < 16 && this.canMoveUp()) {
                List<ResourcePackListEntry> lvt_7_2_ = this.resourcePacksGUI.getListContaining(this);
                int lvt_8_2_ = lvt_7_2_.indexOf(this);
                lvt_7_2_.remove(this);
                lvt_7_2_.add(lvt_8_2_ - 1, this);
                this.resourcePacksGUI.markChanged();
                return true;
            }
            if (p_mousePressed_5_ > 16 && p_mousePressed_6_ > 16 && this.canMoveDown()) {
                List<ResourcePackListEntry> lvt_7_3_ = this.resourcePacksGUI.getListContaining(this);
                int lvt_8_3_ = lvt_7_3_.indexOf(this);
                lvt_7_3_.remove(this);
                lvt_7_3_.add(lvt_8_3_ + 1, this);
                this.resourcePacksGUI.markChanged();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setSelected(int p_setSelected_1_, int p_setSelected_2_, int p_setSelected_3_) {
    }

    @Override
    public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_, int p_mouseReleased_4_, int p_mouseReleased_5_, int p_mouseReleased_6_) {
    }

    public boolean isServerPack() {
        return false;
    }
}

