/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.gson.JsonParseException;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackListEntry;
import net.minecraft.client.resources.data.PackMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ResourcePackListEntryServer
extends ResourcePackListEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IResourcePack resourcePack;
    private final ResourceLocation resourcePackIcon;

    public ResourcePackListEntryServer(GuiScreenResourcePacks p_i46594_1_, IResourcePack p_i46594_2_) {
        super(p_i46594_1_);
        DynamicTexture lvt_3_2_;
        this.resourcePack = p_i46594_2_;
        try {
            DynamicTexture lvt_3_1_ = new DynamicTexture(p_i46594_2_.getPackImage());
        }
        catch (IOException lvt_4_1_) {
            lvt_3_2_ = TextureUtil.MISSING_TEXTURE;
        }
        this.resourcePackIcon = this.mc.getTextureManager().getDynamicTextureLocation("texturepackicon", lvt_3_2_);
    }

    @Override
    protected int getResourcePackFormat() {
        return 3;
    }

    @Override
    protected String getResourcePackDescription() {
        try {
            PackMetadataSection lvt_1_1_ = (PackMetadataSection)this.resourcePack.getPackMetadata(this.mc.getResourcePackRepository().rprMetadataSerializer, "pack");
            if (lvt_1_1_ != null) {
                return lvt_1_1_.getPackDescription().getFormattedText();
            }
        }
        catch (JsonParseException lvt_1_2_) {
            LOGGER.error("Couldn't load metadata info", (Throwable)lvt_1_2_);
        }
        catch (IOException lvt_1_3_) {
            LOGGER.error("Couldn't load metadata info", (Throwable)lvt_1_3_);
        }
        return (Object)((Object)TextFormatting.RED) + "Missing " + "pack.mcmeta" + " :(";
    }

    @Override
    protected boolean canMoveRight() {
        return false;
    }

    @Override
    protected boolean canMoveLeft() {
        return false;
    }

    @Override
    protected boolean canMoveUp() {
        return false;
    }

    @Override
    protected boolean canMoveDown() {
        return false;
    }

    @Override
    protected String getResourcePackName() {
        return "Server";
    }

    @Override
    protected void bindResourcePackIcon() {
        this.mc.getTextureManager().bindTexture(this.resourcePackIcon);
    }

    @Override
    protected boolean showHoverOverlay() {
        return false;
    }

    @Override
    public boolean isServerPack() {
        return true;
    }
}

