/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LegacyV2Adapter;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.client.resources.data.PackMetadataSection;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ResourcePackRepository {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FileFilter RESOURCE_PACK_FILTER = new FileFilter(){

        @Override
        public boolean accept(File p_accept_1_) {
            boolean lvt_2_1_ = p_accept_1_.isFile() && p_accept_1_.getName().endsWith(".zip");
            boolean lvt_3_1_ = p_accept_1_.isDirectory() && new File(p_accept_1_, "pack.mcmeta").isFile();
            return lvt_2_1_ || lvt_3_1_;
        }
    };
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final ResourceLocation UNKNOWN_PACK_TEXTURE = new ResourceLocation("textures/misc/unknown_pack.png");
    private final File dirResourcepacks;
    public final IResourcePack rprDefaultResourcePack;
    private final File dirServerResourcepacks;
    public final MetadataSerializer rprMetadataSerializer;
    private IResourcePack resourcePackInstance;
    private final ReentrantLock lock = new ReentrantLock();
    private ListenableFuture<Object> downloadingPacks;
    private List<Entry> repositoryEntriesAll = Lists.newArrayList();
    private final List<Entry> repositoryEntries = Lists.newArrayList();

    public ResourcePackRepository(File p_i45101_1_, File p_i45101_2_, IResourcePack p_i45101_3_, MetadataSerializer p_i45101_4_, GameSettings p_i45101_5_) {
        this.dirResourcepacks = p_i45101_1_;
        this.dirServerResourcepacks = p_i45101_2_;
        this.rprDefaultResourcePack = p_i45101_3_;
        this.rprMetadataSerializer = p_i45101_4_;
        this.fixDirResourcepacks();
        this.updateRepositoryEntriesAll();
        Iterator<String> lvt_6_1_ = p_i45101_5_.resourcePacks.iterator();
        block0: while (lvt_6_1_.hasNext()) {
            String lvt_7_1_ = lvt_6_1_.next();
            for (Entry lvt_9_1_ : this.repositoryEntriesAll) {
                if (!lvt_9_1_.getResourcePackName().equals(lvt_7_1_)) continue;
                if (lvt_9_1_.getPackFormat() == 3 || p_i45101_5_.incompatibleResourcePacks.contains(lvt_9_1_.getResourcePackName())) {
                    this.repositoryEntries.add(lvt_9_1_);
                    continue block0;
                }
                lvt_6_1_.remove();
                LOGGER.warn("Removed selected resource pack {} because it's no longer compatible", new Object[]{lvt_9_1_.getResourcePackName()});
            }
        }
    }

    public static Map<String, String> getDownloadHeaders() {
        HashMap lvt_0_1_ = Maps.newHashMap();
        lvt_0_1_.put("X-Minecraft-Username", Minecraft.getMinecraft().getSession().getUsername());
        lvt_0_1_.put("X-Minecraft-UUID", Minecraft.getMinecraft().getSession().getPlayerID());
        lvt_0_1_.put("X-Minecraft-Version", "1.11.2");
        return lvt_0_1_;
    }

    private void fixDirResourcepacks() {
        if (this.dirResourcepacks.exists()) {
            if (!(this.dirResourcepacks.isDirectory() || this.dirResourcepacks.delete() && this.dirResourcepacks.mkdirs())) {
                LOGGER.warn("Unable to recreate resourcepack folder, it exists but is not a directory: {}", new Object[]{this.dirResourcepacks});
            }
        } else if (!this.dirResourcepacks.mkdirs()) {
            LOGGER.warn("Unable to create resourcepack folder: {}", new Object[]{this.dirResourcepacks});
        }
    }

    private List<File> getResourcePackFiles() {
        if (this.dirResourcepacks.isDirectory()) {
            return Arrays.asList(this.dirResourcepacks.listFiles(RESOURCE_PACK_FILTER));
        }
        return Collections.emptyList();
    }

    private IResourcePack getResourcePack(File p_getResourcePack_1_) {
        FileResourcePack lvt_2_2_;
        if (p_getResourcePack_1_.isDirectory()) {
            FolderResourcePack lvt_2_1_ = new FolderResourcePack(p_getResourcePack_1_);
        } else {
            lvt_2_2_ = new FileResourcePack(p_getResourcePack_1_);
        }
        try {
            PackMetadataSection lvt_3_1_ = (PackMetadataSection)lvt_2_2_.getPackMetadata(this.rprMetadataSerializer, "pack");
            if (lvt_3_1_ != null && lvt_3_1_.getPackFormat() == 2) {
                return new LegacyV2Adapter(lvt_2_2_);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lvt_2_2_;
    }

    public void updateRepositoryEntriesAll() {
        ArrayList lvt_1_1_ = Lists.newArrayList();
        for (File lvt_3_1_ : this.getResourcePackFiles()) {
            Entry lvt_4_1_ = new Entry(lvt_3_1_);
            if (this.repositoryEntriesAll.contains(lvt_4_1_)) {
                int lvt_5_1_ = this.repositoryEntriesAll.indexOf(lvt_4_1_);
                if (lvt_5_1_ <= -1 || lvt_5_1_ >= this.repositoryEntriesAll.size()) continue;
                lvt_1_1_.add(this.repositoryEntriesAll.get(lvt_5_1_));
                continue;
            }
            try {
                lvt_4_1_.updateResourcePack();
                lvt_1_1_.add(lvt_4_1_);
            }
            catch (Exception lvt_5_2_) {
                lvt_1_1_.remove(lvt_4_1_);
            }
        }
        this.repositoryEntriesAll.removeAll(lvt_1_1_);
        for (Entry lvt_3_2_ : this.repositoryEntriesAll) {
            lvt_3_2_.closeResourcePack();
        }
        this.repositoryEntriesAll = lvt_1_1_;
    }

    @Nullable
    public Entry getResourcePackEntry() {
        if (this.resourcePackInstance != null) {
            Entry lvt_1_1_ = new Entry(this.resourcePackInstance);
            try {
                lvt_1_1_.updateResourcePack();
                return lvt_1_1_;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<Entry> getRepositoryEntriesAll() {
        return ImmutableList.copyOf(this.repositoryEntriesAll);
    }

    public List<Entry> getRepositoryEntries() {
        return ImmutableList.copyOf(this.repositoryEntries);
    }

    public void setRepositories(List<Entry> p_setRepositories_1_) {
        this.repositoryEntries.clear();
        this.repositoryEntries.addAll(p_setRepositories_1_);
    }

    public File getDirResourcepacks() {
        return this.dirResourcepacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Object> downloadResourcePack(String p_downloadResourcePack_1_, String p_downloadResourcePack_2_) {
        String lvt_3_1_ = DigestUtils.sha1Hex((String)p_downloadResourcePack_1_);
        final String lvt_4_1_ = SHA1.matcher(p_downloadResourcePack_2_).matches() ? p_downloadResourcePack_2_ : "";
        final File lvt_5_1_ = new File(this.dirServerResourcepacks, lvt_3_1_);
        this.lock.lock();
        try {
            this.clearResourcePack();
            if (lvt_5_1_.exists()) {
                if (this.checkHash(lvt_4_1_, lvt_5_1_)) {
                    ListenableFuture<Object> listenableFuture = this.setResourcePackInstance(lvt_5_1_);
                    return listenableFuture;
                }
                LOGGER.warn("Deleting file {}", new Object[]{lvt_5_1_});
                FileUtils.deleteQuietly((File)lvt_5_1_);
            }
            this.deleteOldServerResourcesPacks();
            final GuiScreenWorking lvt_6_1_ = new GuiScreenWorking();
            Map<String, String> lvt_7_1_ = ResourcePackRepository.getDownloadHeaders();
            final Minecraft lvt_8_1_ = Minecraft.getMinecraft();
            Futures.getUnchecked(lvt_8_1_.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    lvt_8_1_.displayGuiScreen(lvt_6_1_);
                }
            }));
            final SettableFuture lvt_9_1_ = SettableFuture.create();
            this.downloadingPacks = HttpUtil.downloadResourcePack(lvt_5_1_, p_downloadResourcePack_1_, lvt_7_1_, 0x3200000, lvt_6_1_, lvt_8_1_.getProxy());
            Futures.addCallback(this.downloadingPacks, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object p_onSuccess_1_) {
                    if (ResourcePackRepository.this.checkHash(lvt_4_1_, lvt_5_1_)) {
                        ResourcePackRepository.this.setResourcePackInstance(lvt_5_1_);
                        lvt_9_1_.set(null);
                    } else {
                        LOGGER.warn("Deleting file {}", new Object[]{lvt_5_1_});
                        FileUtils.deleteQuietly((File)lvt_5_1_);
                    }
                }

                public void onFailure(Throwable p_onFailure_1_) {
                    FileUtils.deleteQuietly((File)lvt_5_1_);
                    lvt_9_1_.setException(p_onFailure_1_);
                }
            });
            ListenableFuture<Object> listenableFuture = this.downloadingPacks;
            return listenableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean checkHash(String p_checkHash_1_, File p_checkHash_2_) {
        try {
            String lvt_3_1_ = DigestUtils.sha1Hex((InputStream)new FileInputStream(p_checkHash_2_));
            if (p_checkHash_1_.isEmpty()) {
                LOGGER.info("Found file {} without verification hash", new Object[]{p_checkHash_2_});
                return true;
            }
            if (lvt_3_1_.toLowerCase(Locale.ROOT).equals(p_checkHash_1_.toLowerCase(Locale.ROOT))) {
                LOGGER.info("Found file {} matching requested hash {}", new Object[]{p_checkHash_2_, p_checkHash_1_});
                return true;
            }
            LOGGER.warn("File {} had wrong hash (expected {}, found {}).", new Object[]{p_checkHash_2_, p_checkHash_1_, lvt_3_1_});
        }
        catch (IOException lvt_3_2_) {
            LOGGER.warn("File {} couldn't be hashed.", new Object[]{p_checkHash_2_, lvt_3_2_});
        }
        return false;
    }

    private boolean validatePack(File p_validatePack_1_) {
        Entry lvt_2_1_ = new Entry(p_validatePack_1_);
        try {
            lvt_2_1_.updateResourcePack();
            return true;
        }
        catch (Exception lvt_3_1_) {
            LOGGER.warn("Server resourcepack is invalid, ignoring it", (Throwable)lvt_3_1_);
            return false;
        }
    }

    private void deleteOldServerResourcesPacks() {
        try {
            ArrayList lvt_1_1_ = Lists.newArrayList((Iterable)FileUtils.listFiles((File)this.dirServerResourcepacks, (IOFileFilter)TrueFileFilter.TRUE, null));
            Collections.sort(lvt_1_1_, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            int lvt_2_1_ = 0;
            for (File lvt_4_1_ : lvt_1_1_) {
                if (lvt_2_1_++ < 10) continue;
                LOGGER.info("Deleting old server resource pack {}", new Object[]{lvt_4_1_.getName()});
                FileUtils.deleteQuietly((File)lvt_4_1_);
            }
        }
        catch (IllegalArgumentException lvt_1_2_) {
            LOGGER.error("Error while deleting old server resource pack : {}", new Object[]{lvt_1_2_.getMessage()});
        }
    }

    public ListenableFuture<Object> setResourcePackInstance(File p_setResourcePackInstance_1_) {
        if (!this.validatePack(p_setResourcePackInstance_1_)) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Invalid resourcepack"));
        }
        this.resourcePackInstance = new FileResourcePack(p_setResourcePackInstance_1_);
        return Minecraft.getMinecraft().scheduleResourcesRefresh();
    }

    @Nullable
    public IResourcePack getResourcePackInstance() {
        return this.resourcePackInstance;
    }

    public void clearResourcePack() {
        this.lock.lock();
        try {
            if (this.downloadingPacks != null) {
                this.downloadingPacks.cancel(true);
            }
            this.downloadingPacks = null;
            if (this.resourcePackInstance != null) {
                this.resourcePackInstance = null;
                Minecraft.getMinecraft().scheduleResourcesRefresh();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class Entry {
        private final IResourcePack reResourcePack;
        private PackMetadataSection rePackMetadataSection;
        private ResourceLocation locationTexturePackIcon;

        private Entry(File p_i1295_2_) {
            this(p_i1295_1_.getResourcePack(p_i1295_2_));
        }

        private Entry(IResourcePack p_i46558_2_) {
            this.reResourcePack = p_i46558_2_;
        }

        public void updateResourcePack() throws IOException {
            this.rePackMetadataSection = (PackMetadataSection)this.reResourcePack.getPackMetadata(ResourcePackRepository.this.rprMetadataSerializer, "pack");
            this.closeResourcePack();
        }

        public void bindTexturePackIcon(TextureManager p_bindTexturePackIcon_1_) {
            BufferedImage lvt_2_1_ = null;
            try {
                lvt_2_1_ = this.reResourcePack.getPackImage();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (lvt_2_1_ == null) {
                try {
                    lvt_2_1_ = TextureUtil.readBufferedImage(Minecraft.getMinecraft().getResourceManager().getResource(UNKNOWN_PACK_TEXTURE).getInputStream());
                }
                catch (IOException lvt_3_1_) {
                    throw new Error("Couldn't bind resource pack icon", lvt_3_1_);
                }
            }
            if (this.locationTexturePackIcon == null) {
                this.locationTexturePackIcon = p_bindTexturePackIcon_1_.getDynamicTextureLocation("texturepackicon", new DynamicTexture(lvt_2_1_));
            }
            p_bindTexturePackIcon_1_.bindTexture(this.locationTexturePackIcon);
        }

        public void closeResourcePack() {
            if (this.reResourcePack instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)this.reResourcePack)));
            }
        }

        public IResourcePack getResourcePack() {
            return this.reResourcePack;
        }

        public String getResourcePackName() {
            return this.reResourcePack.getPackName();
        }

        public String getTexturePackDescription() {
            return this.rePackMetadataSection == null ? (Object)((Object)TextFormatting.RED) + "Invalid pack.mcmeta (or missing 'pack' section)" : this.rePackMetadataSection.getPackDescription().getFormattedText();
        }

        public int getPackFormat() {
            return this.rePackMetadataSection == null ? 0 : this.rePackMetadataSection.getPackFormat();
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ instanceof Entry) {
                return this.toString().equals(p_equals_1_.toString());
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.format("%s:%s", this.reResourcePack.getPackName(), this.reResourcePack instanceof FolderResourcePack ? "folder" : "zip");
        }
    }
}

