/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class SimpleReloadableResourceManager
implements IReloadableResourceManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Joiner JOINER_RESOURCE_PACKS = Joiner.on((String)", ");
    private final Map<String, FallbackResourceManager> domainResourceManagers = Maps.newHashMap();
    private final List<IResourceManagerReloadListener> reloadListeners = Lists.newArrayList();
    private final Set<String> setResourceDomains = Sets.newLinkedHashSet();
    private final MetadataSerializer rmMetadataSerializer;

    public SimpleReloadableResourceManager(MetadataSerializer p_i1299_1_) {
        this.rmMetadataSerializer = p_i1299_1_;
    }

    public void reloadResourcePack(IResourcePack p_reloadResourcePack_1_) {
        for (String s : p_reloadResourcePack_1_.getResourceDomains()) {
            this.setResourceDomains.add(s);
            FallbackResourceManager fallbackresourcemanager = this.domainResourceManagers.get(s);
            if (fallbackresourcemanager == null) {
                fallbackresourcemanager = new FallbackResourceManager(this.rmMetadataSerializer);
                this.domainResourceManagers.put(s, fallbackresourcemanager);
            }
            fallbackresourcemanager.addResourcePack(p_reloadResourcePack_1_);
        }
    }

    @Override
    public Set<String> getResourceDomains() {
        return this.setResourceDomains;
    }

    @Override
    public IResource getResource(ResourceLocation p_getResource_1_) throws IOException {
        IResourceManager iresourcemanager = this.domainResourceManagers.get(p_getResource_1_.getResourceDomain());
        if (iresourcemanager != null) {
            return iresourcemanager.getResource(p_getResource_1_);
        }
        throw new FileNotFoundException(p_getResource_1_.toString());
    }

    @Override
    public List<IResource> getAllResources(ResourceLocation p_getAllResources_1_) throws IOException {
        IResourceManager iresourcemanager = this.domainResourceManagers.get(p_getAllResources_1_.getResourceDomain());
        if (iresourcemanager != null) {
            return iresourcemanager.getAllResources(p_getAllResources_1_);
        }
        throw new FileNotFoundException(p_getAllResources_1_.toString());
    }

    private void clearResources() {
        this.domainResourceManagers.clear();
        this.setResourceDomains.clear();
    }

    @Override
    public void reloadResources(List<IResourcePack> p_reloadResources_1_) {
        ProgressManager.ProgressBar resReload = ProgressManager.push("Loading Resources", p_reloadResources_1_.size() + 1, true);
        this.clearResources();
        LOGGER.info("Reloading ResourceManager: {}", new Object[]{JOINER_RESOURCE_PACKS.join(Iterables.transform(p_reloadResources_1_, (Function)new Function<IResourcePack, String>(){

            public String apply(IResourcePack p_apply_1_) {
                return p_apply_1_ == null ? "<NULL>" : p_apply_1_.getPackName();
            }
        }))});
        for (IResourcePack iresourcepack : p_reloadResources_1_) {
            resReload.step(iresourcepack.getPackName());
            this.reloadResourcePack(iresourcepack);
        }
        resReload.step("Reloading listeners");
        this.notifyReloadListeners();
        ProgressManager.pop(resReload);
    }

    @Override
    public void registerReloadListener(IResourceManagerReloadListener p_registerReloadListener_1_) {
        ProgressManager.ProgressBar resReload = ProgressManager.push("Loading Resource", 1);
        resReload.step(p_registerReloadListener_1_.getClass(), new String[0]);
        this.reloadListeners.add(p_registerReloadListener_1_);
        p_registerReloadListener_1_.onResourceManagerReload(this);
        ProgressManager.pop(resReload);
    }

    private void notifyReloadListeners() {
        ProgressManager.ProgressBar resReload = ProgressManager.push("Reloading", this.reloadListeners.size());
        for (IResourceManagerReloadListener iresourcemanagerreloadlistener : this.reloadListeners) {
            resReload.step(iresourcemanagerreloadlistener.getClass(), new String[0]);
            iresourcemanagerreloadlistener.onResourceManagerReload(this);
        }
        ProgressManager.pop(resReload);
    }
}

