/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class SimpleResource
implements IResource {
    private final Map<String, IMetadataSection> mapMetadataSections = Maps.newHashMap();
    private final String resourcePackName;
    private final ResourceLocation srResourceLocation;
    private final InputStream resourceInputStream;
    private final InputStream mcmetaInputStream;
    private final MetadataSerializer srMetadataSerializer;
    private boolean mcmetaJsonChecked;
    private JsonObject mcmetaJson;

    public SimpleResource(String p_i46090_1_, ResourceLocation p_i46090_2_, InputStream p_i46090_3_, InputStream p_i46090_4_, MetadataSerializer p_i46090_5_) {
        this.resourcePackName = p_i46090_1_;
        this.srResourceLocation = p_i46090_2_;
        this.resourceInputStream = p_i46090_3_;
        this.mcmetaInputStream = p_i46090_4_;
        this.srMetadataSerializer = p_i46090_5_;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.srResourceLocation;
    }

    @Override
    public InputStream getInputStream() {
        return this.resourceInputStream;
    }

    @Override
    public boolean hasMetadata() {
        return this.mcmetaInputStream != null;
    }

    @Override
    @Nullable
    public <T extends IMetadataSection> T getMetadata(String p_getMetadata_1_) {
        IMetadataSection lvt_2_2_;
        if (!this.hasMetadata()) {
            return null;
        }
        if (this.mcmetaJson == null && !this.mcmetaJsonChecked) {
            this.mcmetaJsonChecked = true;
            BufferedReader lvt_2_1_ = null;
            try {
                lvt_2_1_ = new BufferedReader(new InputStreamReader(this.mcmetaInputStream));
                this.mcmetaJson = new JsonParser().parse((Reader)lvt_2_1_).getAsJsonObject();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lvt_2_1_);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)lvt_2_1_);
        }
        if ((lvt_2_2_ = this.mapMetadataSections.get(p_getMetadata_1_)) == null) {
            lvt_2_2_ = this.srMetadataSerializer.parseMetadataSection(p_getMetadata_1_, this.mcmetaJson);
        }
        return (T)lvt_2_2_;
    }

    @Override
    public String getResourcePackName() {
        return this.resourcePackName;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof SimpleResource)) {
            return false;
        }
        SimpleResource lvt_2_1_ = (SimpleResource)p_equals_1_;
        if (this.srResourceLocation != null ? !this.srResourceLocation.equals(lvt_2_1_.srResourceLocation) : lvt_2_1_.srResourceLocation != null) {
            return false;
        }
        return !(this.resourcePackName != null ? !this.resourcePackName.equals(lvt_2_1_.resourcePackName) : lvt_2_1_.resourcePackName != null);
    }

    public int hashCode() {
        int lvt_1_1_ = this.resourcePackName != null ? this.resourcePackName.hashCode() : 0;
        lvt_1_1_ = 31 * lvt_1_1_ + (this.srResourceLocation != null ? this.srResourceLocation.hashCode() : 0);
        return lvt_1_1_;
    }

    @Override
    public void close() throws IOException {
        this.resourceInputStream.close();
        if (this.mcmetaInputStream != null) {
            this.mcmetaInputStream.close();
        }
    }
}

